public class ColorPoint extends Point {
    private Color color;

    public ColorPoint(int x, int y, Color color) {
        super(x, y);
        this.color = color;
    }

/* WYKOMENTOWANE

    // Bd - naruszona symetria!
    public boolean equals(Object o) {
        if (!(o instanceof ColorPoint))
            return false;
        ColorPoint cp = (ColorPoint)o;
        return super.equals(o) && cp.color == color;
    }

*/

    // Bd - naruszona przechodnio
    public boolean equals(Object o) {
        if (!(o instanceof Point))
            return false;

        // Jeeli o jest zwykym punktem, 
        // przeprowad porwnanie bez uwzgldniania koloru
        if (!(o instanceof ColorPoint))
            return o.equals(this);

        // Jeeli o jest punktem kolorowym przeprowad pene porwnanie
        ColorPoint cp = (ColorPoint)o;
        return super.equals(o) && cp.color == color;
    }

    // ...  // Pozostaa cz pominita

    public static void main(String[] args) {
        // Test symetrii
        Point p = new Point(1, 2);
        ColorPoint cp = new ColorPoint(1, 2, Color.RED);
        System.out.println(p.equals(cp));
        System.out.println(cp.equals(p));
        System.out.println();

        // Test przechodnioci
        ColorPoint p1 = new ColorPoint(1, 2, Color.RED);
        Point p2 = new Point(1, 2);
        ColorPoint p3 = new ColorPoint(1, 2, Color.BLUE);
        System.out.println(p1.equals(p2));
        System.out.println(p2.equals(p3));
        System.out.println(p1.equals(p3));
    }
}
