// Klasa PhoneNumber implementujca Comparable

import java.util.*;

public final class PhoneNumber implements Comparable {
    private final short areaCode;
    private final short exchange;
    private final short extension;

    public PhoneNumber(int areaCode, int exchange,
                       int extension) {
        rangeCheck(areaCode,   999, "nr kierunkowy");
        rangeCheck(exchange,   999, "centrala");
        rangeCheck(extension, 9999, "rozszerzenie");
        this.areaCode  = (short) areaCode;
        this.exchange  = (short) exchange;
        this.extension = (short) extension;
 
    }

    private static void rangeCheck(int arg, int max,
                                   String name) {
        if (arg < 0 || arg > max)
           throw new IllegalArgumentException(name +": " + arg);
    }

    public boolean equals(Object o) {
        if (o == this)
            return true;
        if (!(o instanceof PhoneNumber))
            return false;
        PhoneNumber pn = (PhoneNumber)o;
        return pn.extension == extension &&
               pn.exchange  == exchange  &&
               pn.areaCode  == areaCode;
    }

    public int hashCode() {
        int result = 17;
        result = 37*result + areaCode;
        result = 37*result + exchange;
        result = 37*result + extension;
        return result;
    }

/* WYKOMENTOWANE

    public int compareTo(Object o) {
        PhoneNumber pn = (PhoneNumber)o;

        // Porwnanie numerw kierunkowych
        if (areaCode < pn.areaCode)
            return -1;
        if (areaCode > pn.areaCode)
            return  1;

        // Numery kierunkowe s rwne, porwnanie numerw central
        if (exchange < pn.exchange)
            return -1;
        if (exchange > pn.exchange)
            return  1;

        // Numery kierunkowe i central s rwne, porwnanie rozszerze
        if (extension < pn.extension)
            return -1;
        if (extension > pn.extension)
            return  1;

        return 0;  // Wszystkie pola s rwne
    }

*/

    public int compareTo(Object o) {
        PhoneNumber pn = (PhoneNumber)o;

        // Porwnanie numerw kierunkowych
        int areaCodeDiff = areaCode - pn.areaCode;
        if (areaCodeDiff != 0)
            return areaCodeDiff;

        // Numery kierunkowe s rwne, porwnanie numerw central
        int exchangeDiff = exchange - pn.exchange;
        if (exchangeDiff != 0)
            return exchangeDiff;

        // Numery kierunkowe i central s rwne, porwnanie rozszerze
        return extension - pn.extension;
    }

    /**
     * Zwraca cig reprezentujcy ten numer telefonu.
     * Cig skada si z czternastu znakw w formacie
     * "(XXX) YYY-ZZZZ", gdzie XXX jest numerem kierunkowym, YYY to
     * centrala a ZZZZ rozszerzenie. (Kada litera reprezentuje
     * jedn cyfr.)
     *
     * Jeeli dowolna z tych trzech czci jest zbyt maa 
     * aby wypeni swoje pole, jest ono uzupeniane z lewej strony zerami.
     *  Na przykad, jeeli rozszerzenie ma numer 123, ostatnie 
     * cztery znaki cigu bd miay posta "0123".
     *
     * Za zamykajcym nawiasem znajduje si spacja oddzielajca 
     * numer kierunkowy od numeru centrali
     */
    public String toString() {
        return "(" + toPaddedString(areaCode, 3) + ") " +
                toPaddedString(exchange,  3) + "-" +
                toPaddedString(extension, 4);
    }

    /**
     * Zamienia liczb typu int na cig o podanej dugoci
     * dopeniony z lewej strony zerami. Zakadamy i >= 0,
     * 1 <= dugo <= 10, i Integer.toString(i) <= dugo.
     */
    private static String toPaddedString(int i, int length) {
        String s = Integer.toString(i);
        return ZEROS[length - s.length()] + s;
    }
    private static String[] ZEROS =
        {"", "0", "00", "000", "0000", "00000", 
         "000000", "0000000", "00000000", "000000000"};

    // ... // Pozostaa cz pominita

    public static void main(String args[]) {
        int n = Integer.parseInt(args[0]);

        Random rnd = new Random();
        PhoneNumber[] a = new PhoneNumber[n];
        for (int i=0; i<n; i++)
            a[i] = new PhoneNumber(rnd.nextInt(1000), rnd.nextInt(1000),
                                   rnd.nextInt(10000)); 
        Arrays.sort(a);
        System.out.println(Arrays.asList(a));
    }
}
