// ExploreType.java

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ExploreType
{
   public static void main(String[] args)
   {
      if (args.length != 1)
      {
         System.err.println("uycie: java ExploreType nazwaPakietuITypu");
         return;
      }
      try
      {
         Class<?> clazz = Class.forName(args[0]);
         System.out.println("NAZWA: " + clazz.getName());
         System.out.println("PAKIET: " + clazz.getPackage().getName());
         System.out.println("POLA");
         Field[] fields = clazz.getDeclaredFields();
         for (int i = 0; i < fields.length; i++)
            System.out.println(fields[i]);
         System.out.println("KONSTRUKTORY");
         Constructor[] constructors = clazz.getDeclaredConstructors();
         for (int i = 0; i < constructors.length; i++)
            System.out.println(constructors[i]);
         System.out.println("METODY");
         Method[] methods = clazz.getDeclaredMethods();
         for (int i = 0; i < methods.length; i++)
            System.out.println(methods[i]);
      }
      catch (ClassNotFoundException cnfe)
      {
         System.err.println("nie mona znale " + args[0]);
      }
   }
}
