// Copy.java

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Copy
{
   public static void main(String[] args)
   {
      if (args.length != 2)
      {
         System.err.println("uycie: java Copy plikrdowy plikdocelowy");
         return;
      }
      FileInputStream fis = null;
      try
      {
         fis = new FileInputStream(args[0]);
         FileOutputStream fos = null;
         try
         {
            fos = new FileOutputStream(args[1]);
            int b; // wybraem b zamiast byte, poniewa byte jest sowem zastrzeonym.
            while ((b = fis.read()) != -1)
               fos.write(b);
         }
         catch (FileNotFoundException fnfe)
         {
            String msg = "Nie mona utworzy " + args[1] + "; by moe " + 
                         "jest to katalog";
            System.err.println(msg);
         }
         catch (IOException ioe)
         {
            String msg = "Nie mona odczyta " + args[0] + 
                         " albo nie mona zapisa danych do " + args[1];
            System.err.println(msg);
         }
         finally
         {
            if (fos != null)
               try
               {
                  fos.close();
               }
               catch (IOException ioe)
               {
                  System.err.println("Nie mona zamkn " + args[1]);
               }
         }
      }
      catch (FileNotFoundException fnfe)
      {
         String msg = "Nie mona znale " + args[0] + " lub jest to katalog";
         System.err.println(msg);
      }
      finally
      {
         if (fis != null)
            try
            {
               fis.close();
            }
            catch (IOException ioe)
            {
               System.err.println("Nie mona zamkn " + args[0]);
            }
      }
   }
}
