// DiscardPile.java

import java.util.ArrayList;
import java.util.List;

/**
 *  Symulacja stosu kart odrzuconych.
 *
 *  @author Jeff Friesen
 */
public class DiscardPile
{
   private Card[] cards;
   private int top;
   /**
    *  Tworzy stos kart <code>DiscardPile</code>, w ktrym mog si znajdowa maksymalnie
    *  52 karty <code>Card</code>. Stos <code>DiscardPile</code> jest na pocztku pusty.
    */
   public DiscardPile()
   {
      cards = new Card[52]; // Miejsce na wszystkie karty na stosie
                            // (nigdy nie powinno by potrzebne).
      top = -1;
   }
   /**
    *  Zwraca kart <code>Card</code> na gr stosu <code>DiscardPile</code>.
    *
    *  @return obiekt karty <code>Card</code> na grze stosu <code>DiscardPile</code> lub
    *  null, jeli stos <code>DiscardPile</code> jest pusty
    */
   public Card getTopCard()
   {
      if (top == -1)
         return null;
      Card card = cards[top];
      cards[top--] = null;
      return card;
   }
   /**
    *  Wskazuje obiekt karty <code>Card</code> jako kart na grze stosu <code>DiscardPile</code>.
    *
    *  @param card obiekt karty <code>Card</code> rzucanej na gr stosu <code>DiscardPile</code>
    */
   public void setTopCard(Card card)
   {
      cards[++top] = card;
   }
   /**
    *  Identyfikuje kart <code>Card</code> na grze stosu <code>DiscardPile</code>
    *  bez usuwania tej karty.
    *
    *  @return karta <code>Card</code> z gry stosu lub null jeli stos
    *  <code>DiscardPile</code> jest pusty
    */
   public Card topCard()
   {
      return (top == -1) ? null : cards[top];
   }
}
