// SerializationDemo.java

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

import java.util.StringTokenizer;

class SerializableStringTokenizer extends StringTokenizer
   implements Serializable
{
   SerializableStringTokenizer(String str)
   {
      super(str);
   }
   SerializableStringTokenizer(String str, String delim)
   {
      super(str, delim);
   }
   SerializableStringTokenizer(String str, String delim,
                               boolean returnDelims)
   {
      super(str, delim, returnDelims);
   }
}
public class SerializationDemo
{
   public static void main(String[] args)
   {
      try
      {
         SerializableStringTokenizer sst;
         sst = new SerializableStringTokenizer("Zażółć gęślą jaźń");
         System.out.println("Liczba leksemów = " + sst.countTokens());
         System.out.println("Pierwszy leksem = " + sst.nextToken());
         ByteArrayOutputStream baos = new ByteArrayOutputStream();
         ObjectOutputStream oos = new ObjectOutputStream(baos);
         oos.writeObject(sst);
         oos.close();
         System.out.println("Obiekt sst został zapisany w tablicy bajtów");
         ByteArrayInputStream bais;
         bais = new ByteArrayInputStream(baos.toByteArray());
         ObjectInputStream ois = new ObjectInputStream(bais);
         Object o = ois.readObject();
         System.out.println("Obiekt sst został odczytany z tablicy bajtów ");
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
   }
}
