// FileDirectoryInfo.java

import java.io.File;
import java.io.IOException;

import java.util.Date;

public class FileDirectoryInfo
{
   public static void main(final String[] args) throws IOException
   {
      if (args.length != 1)
      {
         System.err.println("wywołanie: java FileDirectoryInfo ścieżka");
         return;
      }
      File file = new File(args[0]);
      System.out.println("Plik/katalog " + file + ":");
      System.out.println("Czy można odczytać = " + file.canRead());
      System.out.println("Czy można zapisać = " + file.canWrite());
      System.out.println("Czy istnieje = " + file.exists());
      System.out.println("Czy jest katalogiem = " + file.isDirectory());
      System.out.println("Czy jest plikiem = " + file.isFile());
      System.out.println("Czy jest ukryty = " + file.isHidden());
      System.out.println("Ostatnia modyfikacja = " + new Date(file.lastModified()));
      System.out.println("Rozmiar = " + file.length());
   }
}
