// MergeArrays.java

public class MergeArrays
{
   public static void main(String[] args)
   {
      int[] x = { 1, 2, 3, 4, 5 };
      int[] y = { 1, 2, 7, 9 };
      int[] result = merge(x, y);
      for (int i = 0; i < result.length; i++)
         System.out.println(result[i]);
   }
   public static int[] merge(int[] a, int[] b)
   {
      if (a == null)
         throw new NullPointerException("a jest null");
      if (b == null)
         throw new NullPointerException("b jest null");
      int[] result = new int[a.length+b.length];
      // Warunek pocztkowy
      assert result.length == a.length+b.length: "dugo nieprawidowa";
      for (int i = 0; i < a.length; i++)
         result[i] = a[i];
      for (int i = 0; i < b.length; i++)
         result[a.length+i-1] = b[i];
      // Warunek kocowy
      assert containsAll(result, a, b): "brak wartoci w tablicy";
      return result;
   }
   private static boolean containsAll(int[] result, int[] a, int[] b)
   {
      for (int i = 0; i < a.length; i++)
         if (!contains(result, a[i]))
            return false;
      for (int i = 0; i < b.length; i++)
         if (!contains(result, b[i]))
            return false;
      return true;
   }
   private static boolean contains(int[] a, int val)
   {
      for (int i = 0; i < a.length; i++)
         if (a[i] == val)
            return true;
      return false;
   }
}

