// Copy.java

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Copy
{
   public static void main(String[] args)
   {
      if (args.length != 2)
      {
         System.err.println("uycie: java Copy plikrdowy plikdocelowy");
         return;
      }
      try
      {
         copy(args[0], args[1]);
      }
      catch (FileNotFoundException fnfe)
      {
         String msg = "Nie mona znale " + args[0] + " lub jest to katalog," + 
                      " bd te " + args[1] + " nie moe zosta utworzony, " + 
                      "by moe dlatego, e " + args[1] + " to katalog";
         System.err.println(msg);
      }
      catch (IOException ioe)
      {
         String msg = "Nie mona odczyta " + args[0] + 
                      " albo nie mona zapisa danych do " + args[1];
         System.err.println(msg);
      }
   }
   static void copy(String srcFile, String dstFile) throws IOException
   {
      FileInputStream fis = new FileInputStream(srcFile);
      try
      {
         FileOutputStream fos = new FileOutputStream(dstFile);
         try
         {
            int b;
            while ((b = fis.read()) != -1)
               fos.write(b);
         }
         finally
         {
            try
            {
               fos.close();
            }
            catch (IOException ioe)
            {
               System.err.println("Nie mona zamkn " + dstFile);
            }
         }
      }
      finally
      {
         try
         {
            fis.close();
         }
         catch (IOException ioe)
         {
            System.err.println("Nie mona zamkn " + srcFile);
         }
      }
   }
}
