/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 11. Ewaluacja leniwa
 *
 * Listing 11.3. Aktualizowanie obiektu User za pomoc gorliwych argumentw metody
 */

import java.util.Collections;
import java.util.List;


record Role(String name) {}

record User(List<Role> roles) {}

User updateUser(User user,
                List<Role> availableRoles) {
    return new User(availableRoles);
}

class DAO {
    public List<Role> loadAllAvailableRoles() {
        return List.of(new Role("admin"),
                       new Role("go"));
    }
}

var dao = new DAO();

// SPOSB UYCIA

var user = new User(Collections.emptyList());

var availableRoles = dao.loadAllAvailableRoles();

var updatedUser = updateUser(user, availableRoles);
