/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 2. Funkcyjna Java
 * 
 * Listing 2.9. Memoizacja z wykorzystaniem Map#computeIfAbsent
 */

Map<String, Object> cache = new HashMap<>();

<T> T memoize(String identifier, Supplier<T> fn) {
    return (T) cache.computeIfAbsent(identifier,
                                     key -> fn.get());
}


Integer expensiveCall(String arg0, int arg1) {
    try {
        System.out.println("Upienie na 3 s.");
        Thread.sleep(3_000);
    } catch (InterruptedException e) {
        // ...
    }

    return arg1;
}

Integer memoizedCall(String arg0, int arg1) {
    var compoundKey = String.format("expensiveCall:%s-%d", arg0, arg1);

    return memoize(compoundKey,
                   () -> expensiveCall(arg0, arg1));
}


var calculated = memoizedCall("witaj, wiecie!", 42);
var memoized = memoizedCall("witaj, wiecie!", 42);
