/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 13. Zadania asynchroniczne
 *
 * Listing 13.5. Operacje Either i odrzucone etapy
 */

import java.util.concurrent.CompletableFuture;

CompletableFuture<String> notFailed =
    CompletableFuture.supplyAsync(() -> "Powodzenie!");

CompletableFuture<String> failed =
    CompletableFuture.supplyAsync(() -> { throw new RuntimeException(); });


// BRAK DANYCH WYJCIOWYCH, PONIEWA POPRZEDNI ETAP SI NIE POWID
var rejected = failed.acceptEither(notFailed, System.out::println);

// S DANE WYJCIOWE, PONIEWA POPRZEDNI ETAP ZAKOCZY SI NORMALNIE
var resolved = notFailed.acceptEither(failed, System.out::println);
