/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 9. Obsuga wartoci null za pomoc typw Optional
 *
 * Listing 9.5. adowanie zawartoci za pomoc opcyjnego acucha wywoa
 */

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

record Content(boolean isPublished) { }

Optional<Content> loadFromDB(String identifier) {
    return Optional.of(new Content(false));
}

Map<String, Content> cache = new HashMap<>();

Optional<Content> get(String contentId) {
    return Optional.ofNullable(contentId) 
                   .filter(Predicate.not(String::isBlank)) 
                   .map(String::toLowerCase) 
                   .map(cache::get)
                   .or(() -> loadFromDB(contentId)) 
                   .filter(Content::isPublished); 
}

get("ABC");
