/*
 * FUNKCYJNE PODEJCIE DO JAVY
 * Rozdzia 7. Praca ze strumieniami
 */

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

record User(UUID id,
            String group,
            LocalDateTime lastLogin,
            List<String> logEntries) { }

List<User> users = List.of(
    new User(UUID.randomUUID(), "admin", LocalDateTime.now().minusDays(23L), List.of("1", "2")),
    new User(UUID.randomUUID(), "user", null, Collections.emptyList()),
    new User(UUID.randomUUID(), "user", LocalDateTime.now().minusDays(42L), List.of("A", "B"))
);


var collectIdsToSet = Collectors.mapping(User::id,
                                         Collectors.toSet());
Map<String, Set<UUID>> lookup =
  users.stream()
       .collect(Collectors.groupingBy(User::group,
                                      collectIdsToSet));
