﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class RPGGameManager : MonoBehaviour
{
    public SpawnPoint playerSpawnPoint;

    public static RPGGameManager sharedInstance = null;
    public RPGCameraManager cameraManager;

    void Awake()
    {
        if (sharedInstance != null && sharedInstance != this)
        {
            // Dozwolona jest tylko jedna instancja, więc usuwamy inne istniejące obiekty
            Destroy(gameObject);
        }
        else
        {
            // Jeżeli jest to ostatnia instancja, przypisujemy właściwości sharedInstance bieżący obiekt
            sharedInstance = this;
        }
    }

    void Start()
    {
        // Cały kod konfigurujący scenę jest umieszczony w jednej metodzie
        // Dzięki temu w przyszłości łatwiej będzie go wywoływać z innych miejscach niż metoda Start()
        SetupScene();
    }

    public void SetupScene()
    {
        SpawnPlayer();
    }

    public void SpawnPlayer()
    {
        if (playerSpawnPoint != null)
        {
            GameObject player = playerSpawnPoint.SpawnObject();
            cameraManager.virtualCamera.Follow = player.transform;
        }
    }

}
