package app.views;

import app.classes.Defaults;
import app.models.Tweet;
import app.models.UserCredentials;
import app.module.L10n.classes.Locale;
import app.module.ui.classes.GameCanvasView;
import app.module.ui.classes.HorizontalContainer;
import app.module.ui.classes.InputStringItem;
import app.module.ui.classes.Label;
import app.module.ui.classes.SimpleTextButton;
import app.module.ui.classes.StringItem;
import app.module.ui.classes.VerticalContainer;
import app.module.ui.models.CallbackHandler;
import app.module.ui.models.Container;
import app.module.ui.models.UITheme;
import com.apress.framework.core.Application;
import com.apress.framework.objecttypes.EVT;
import com.apress.framework.objecttypes.Event;

public class MainForm extends GameCanvasView implements CallbackHandler
{

    VerticalContainer tweetsContainer = null;

    HorizontalContainer commandButtons = null;
    InputStringItem newTweet = null;
    SimpleTextButton nextTweets = null;
    SimpleTextButton showSettingsForm = null;

    public void addTweet(Tweet tweet)
    {
            String text = tweet.getAuthor() + " : " + tweet.getBody() ;

            StringItem item = new StringItem( text , tweetsContainer.getTotalWidth() - 20,
                    100, this, Defaults.THEME );

            tweetsContainer.addWidget(item);
            tweetsContainer.doLayout();
    }

    public MainForm(UITheme theme)
    {
        super(false,theme);

        // Utwórz nową wiadomość tweet
        newTweet = new InputStringItem(Locale.get("tweets.new.prompt"), Locale.get("tweets.new.prompt"), Locale.get("text.general.ok"), Locale.get("text.general.cancel"),
            getContentWidth()-10, 100, this, theme);

        // Utwórz kontener dla wiadomości
        tweetsContainer = new VerticalContainer(theme);

        // Utwórzy przyciski poleceń
        nextTweets = new SimpleTextButton(Locale.get("tweets.next.label"), this, theme);
        showSettingsForm = new SimpleTextButton(Locale.get("settings.form.button.label"), this, theme);
        commandButtons = new HorizontalContainer(theme);
        commandButtons.addWidget(nextTweets);
        commandButtons.addWidget(showSettingsForm);

        // Dodaj do formularza jego elementy
        addWidget(newTweet);
        addWidget(tweetsContainer);
        addWidget(commandButtons);

        // Utwórz początkowy układ i przenieś fokus
        doLayout();
        onFocus();
    }

    public void doLayout()
    {
        commandButtons.doLayout();
        tweetsContainer.setContentHeight(getTotalHeight() - commandButtons.getTotalHeight() - newTweet.getTotalHeight() - 20);
        tweetsContainer.setContentWidth(getTotalWidth());
        super.doLayout();
    }

    public boolean doCallback(Event event)
    {
        if ( EVT.UI.BUTTON_PRESSED == event.getType() )
        {
            if ( nextTweets == event.getPayload() )
            {
                Event evt = new Event(EVT.CONTEXT.MAIN_FORM, EVT.TWEETS.REQUEST_MAIN_TWEETS_BATCH, null);
                Application.getMainEventController().queueEvent(evt);
                return true;
            }
            else
            if ( showSettingsForm == event.getPayload() )
            {
                Event evt = new Event(EVT.CONTEXT.MAIN_FORM, EVT.PROGRAM_FLOW.SHOW_SETTINGS_SCREEN, null);
                Application.getMainEventController().queueEvent(evt);
                return true;
            }
        }
        else if ( EVT.UI.TEXT_CHANGED == event.getType() )
        {
            // Utwórz nową wiadomość z tekstem StringItem i wyślij ją
            Tweet tweet = new Tweet(null,newTweet.getText(),null);
            Event evt = new Event(EVT.CONTEXT.MAIN_FORM, EVT.TWEETS.POST_TWEET, tweet);
            Application.getMainEventController().queueEvent(evt);

            // Wyczyść tekst StringItem
            newTweet.setText(Locale.get("tweets.new.prompt"));
            return true;
        }
        return false;
    }
}
