package app.module.L10n.classes;

import app.module.ui.helpers.UITextHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;


public class Locale
{
    protected static Hashtable keyValuePairs = new Hashtable();

    public static String getDeviceLocale()
    {
        return System.getProperty("microedition.locale");
    }

    public static String getLocaleFile(String locale)
    {
        if ( locale == null )
        {
            return getLocaleFile(getDeviceLocale());
        }
        return "/app/files/L10n/" + locale + ".bin";
    }

    public static boolean loadFromFileBasedOnPreferences(String specifiedUserLocale, String defaultLocale)
    {
        // Próbuj ładować, kolejno, ustawienia użytkownika, urządzenia i domyślne
        if ( loadFromInternalFile( getLocaleFile(specifiedUserLocale) ) ||
             loadFromInternalFile( getLocaleFile(getDeviceLocale() ) ) ||
             loadFromInternalFile( getLocaleFile(defaultLocale) ) )
        {
            return true;
        }

        // Wszystkie próby zakończone niepowodzeniem
        return false;
    }

    public static boolean loadFromInternalFile(String internalFile)
    {
        try
        {
            InputStream stream = Locale.class.getResourceAsStream(internalFile);
            if ( stream == null )
            {
                return false;
            }
            DataInputStream in = new DataInputStream(stream);
            if ( in.available() == 0 )
            {
                return false;
            }
            return loadFromDataInputStream(in);
        }
        catch (Exception ex)
        {
            return false;
        }
    }

    public static boolean loadFromByteArray(byte [] data, int offset, int length)
    {
        DataInputStream in = new DataInputStream ( new ByteArrayInputStream(data, offset,length) );
        return loadFromDataInputStream(in);
    }

    public static boolean loadFromDataInputStream(DataInputStream in)
    {
        String key, value;
        try
        {
            while ( true )
            {
                key = in.readUTF();
                value = in.readUTF();
                keyValuePairs.put(key, value);
            }
        }
        catch (EOFException ex)
        {
            // End of file, we can stop
        }
        catch (Exception ex)
        {
            // Whoops! Read was not successful
            return false;
        }
        return true;
    }

    public static String get(String key)
    {
        return (String) keyValuePairs.get(key);
    }

    public static String get(String key, int value)
    {
        return get(key, String.valueOf(value) );
    }

public static String get(String key, String parameter)
{
    // Najpierw próbuj odczytać wartość dla klucza uwzględniającego wartość parametru
    String originalStr = get(key + ":" + parameter);


    // Jeżeli brak klucza z parametrem, odczytaj wartość dla klucza ogólnego
    if ( originalStr == null )
    {
        originalStr = get(key);
    }

    // Jeżeli w ogóle nie ma klucza, zwróć null
    if ( originalStr == null )
    {
        return null;
    }

    // Sprawdź, czy jest miejsce do wstawienia parametru
    int placeholderPosition = originalStr.indexOf("{@}");

    // Jeżeli nie ma miejsca do wstawienia parametru, po prostu zwróć wartość
    if ( placeholderPosition == -1 )
    {
        return originalStr;
    }

    // Zastąp znacznik parametru jego wartością i zwróć uzyskany ciąg
    return originalStr.substring(0, placeholderPosition) + parameter +
                originalStr.substring(placeholderPosition+3);
}

    public static void clear()
    {
        keyValuePairs.clear();
    }

    public static String formatDate(String dateFormat, Date date)
    {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        String result;

        String day = String.valueOf(c.get(Calendar.DAY_OF_MONTH));
        result = UITextHelper.strReplace("d", day, dateFormat);

        String month = String.valueOf(c.get(Calendar.MONTH));
        result = UITextHelper.strReplace("m", month, result);

        String year = String.valueOf(c.get(Calendar.YEAR));
        result = UITextHelper.strReplace("y", year, result);

        int dayOfWeek = c.get(Calendar.DAY_OF_WEEK);
        int dayOfWeekIndex = 0;
        switch (dayOfWeek)
        {
            case Calendar.MONDAY:
                dayOfWeekIndex = 1;
                break;

            case Calendar.TUESDAY:
                dayOfWeekIndex = 2;
                break;

            case Calendar.WEDNESDAY:
                dayOfWeekIndex = 3;
                break;

            case Calendar.THURSDAY:
                dayOfWeekIndex = 4;
                break;

            case Calendar.FRIDAY:
                dayOfWeekIndex = 5;
                break;

            case Calendar.SATURDAY:
                dayOfWeekIndex = 6;
                break;

            case Calendar.SUNDAY:
                dayOfWeekIndex = 7;
                break;

            default:
                dayOfWeekIndex = 0;
                break;
        }
        result = UITextHelper.strReplace("D", Locale.get("weekdays.names",dayOfWeekIndex), result);

        return result;
    }

}
