/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest;

import com.twitterapime.model.DefaultEntity;
import com.twitterapime.xauth.Token;
import java.util.Hashtable;

public final class Credential
extends DefaultEntity {
    public Credential(String username, String password) {
        this(username, password, (String)null, (String)null);
    }

    public Credential(String username, String password, String consumerKey, String consumerSecret) {
        if (username == null || (username = username.trim()).length() == 0) {
            throw new IllegalArgumentException("Username must not be empty/null");
        }
        if (password == null || (password = password.trim()).length() == 0) {
            throw new IllegalArgumentException("Password must not be empty/null");
        }
        Hashtable<String, String> credtls = new Hashtable<String, String>(4);
        credtls.put("CREDENTIAL_USERNAME", username);
        credtls.put("CREDENTIAL_PASSWORD", password);
        if (consumerKey != null && (consumerKey = consumerKey.trim()).length() > 0) {
            credtls.put("CREDENTIAL_CONSUMER_KEY", consumerKey);
        }
        if (consumerSecret != null && (consumerSecret = consumerSecret.trim()).length() > 0) {
            credtls.put("CREDENTIAL_CONSUMER_SECRET", consumerSecret);
        }
        this.setData(credtls);
    }

    public Credential(String username, String consumerKey, String consumerSecret, Token accessToken) {
        this(username, "ignored", consumerKey, consumerSecret);
        if (accessToken == null) {
            throw new IllegalArgumentException("accessToken must not be null.");
        }
        this.data.put("CREDENTIAL_ACCESS_TOKEN", accessToken);
    }

    String getBasicHttpAuthCredential() {
        return this.getString("CREDENTIAL_USERNAME") + ':' + this.getString("CREDENTIAL_PASSWORD");
    }

    boolean hasXAuthCredentials() {
        String key = this.getString("CREDENTIAL_CONSUMER_KEY");
        if (key == null || key.trim().length() == 0) {
            return false;
        }
        key = this.getString("CREDENTIAL_CONSUMER_SECRET");
        return key != null && key.trim().length() != 0;
    }

    Token getAccessToken() {
        return (Token)this.getObject("CREDENTIAL_ACCESS_TOKEN");
    }
}

