/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest;

import com.twitterapime.io.HttpRequest;
import com.twitterapime.io.HttpResponse;
import com.twitterapime.io.HttpResponseCodeInterpreter;
import com.twitterapime.parser.Parser;
import com.twitterapime.parser.ParserException;
import com.twitterapime.parser.ParserFactory;
import com.twitterapime.rest.Credential;
import com.twitterapime.rest.FriendshipManager;
import com.twitterapime.rest.RateLimitStatus;
import com.twitterapime.rest.Timeline;
import com.twitterapime.rest.TweetER;
import com.twitterapime.rest.UserAccount;
import com.twitterapime.rest.handler.AccountHandler;
import com.twitterapime.rest.handler.RateLimitStatusHandler;
import com.twitterapime.search.LimitExceededException;
import com.twitterapime.search.Query;
import com.twitterapime.util.StringUtil;
import com.twitterapime.xauth.Token;
import com.twitterapime.xauth.XAuthSigner;
import com.twitterapime.xauth.encoders.Base64Encoder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public final class UserAccountManager {
    private static Hashtable userAccountMngrPoll;
    private static final Hashtable SERVICES_URL;
    public static final String TWITTER_API_URL_SERVICE_ACCOUNT_VERIFY_CREDENTIALS = "TWITTER_API_URL_SERVICE_ACCOUNT_VERIFY_CREDENTIALS";
    public static final String TWITTER_API_URL_SERVICE_OAUTH_ACCESS_TOKEN = "TWITTER_API_URL_SERVICE_OAUTH_ACCESS_TOKEN";
    public static final String TWITTER_API_URL_SERVICE_ACCOUNT_RATE_LIMIT_STATUS = "TWITTER_API_URL_SERVICE_ACCOUNT_RATE_LIMIT_STATUS";
    public static final String TWITTER_API_URL_SERVICE_USERS_SHOW = "TWITTER_API_URL_SERVICE_USERS_SHOW";
    public static final String TWITTER_API_URL_SERVICE_ACCOUNT_UPDATE_PROFILE = "TWITTER_API_URL_SERVICE_ACCOUNT_UPDATE_PROFILE";
    private Credential credential;
    private boolean verified;
    private boolean invalidated;
    private Token token;
    private XAuthSigner signer;

    private String getURL(String serviceKey) {
        return (String)SERVICES_URL.get(serviceKey);
    }

    public void setServiceURL(String serviceKey, String url) {
        SERVICES_URL.put(serviceKey, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized UserAccountManager getInstance(Credential c) {
        if (c == null) {
            throw new IllegalArgumentException("Credential must not be null.");
        }
        UserAccountManager uam = null;
        if (userAccountMngrPoll == null) {
            userAccountMngrPoll = new Hashtable();
        } else {
            Hashtable hashtable = userAccountMngrPoll;
            synchronized (hashtable) {
                uam = (UserAccountManager)userAccountMngrPoll.get(c);
            }
        }
        return uam != null ? uam : new UserAccountManager(c);
    }

    private UserAccountManager(Credential c) {
        this.credential = c;
        if (c.hasXAuthCredentials()) {
            String conKey = c.getString("CREDENTIAL_CONSUMER_KEY");
            String conSec = c.getString("CREDENTIAL_CONSUMER_SECRET");
            this.signer = new XAuthSigner(conKey, conSec);
        }
    }

    public RateLimitStatus getRateLimitStatus() throws IOException, LimitExceededException {
        this.checkValid();
        this.checkVerified();
        HttpRequest req = this.createRequest(this.getURL(TWITTER_API_URL_SERVICE_ACCOUNT_RATE_LIMIT_STATUS));
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getDefaultParser();
            RateLimitStatusHandler handler = new RateLimitStatusHandler();
            parser.parse(resp.getStream(), handler);
            RateLimitStatus rateLimitStatus = handler.getParsedRateLimitStatus();
            return rateLimitStatus;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    public boolean isVerified() {
        this.checkValid();
        return this.verified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean verifyCredential() throws IOException, LimitExceededException {
        HttpRequest req;
        this.checkValid();
        if (this.verified) {
            return true;
        }
        if (this.credential.hasXAuthCredentials()) {
            this.token = this.credential.getAccessToken();
            if (this.token != null) {
                this.verified = true;
                return true;
            }
            String user = this.credential.getString("CREDENTIAL_USERNAME");
            String pass = this.credential.getString("CREDENTIAL_PASSWORD");
            req = this.createRequest(this.getURL(TWITTER_API_URL_SERVICE_OAUTH_ACCESS_TOKEN));
            req.setMethod("POST");
            this.signer.signForAccessToken(req, user, pass);
        } else {
            req = this.createRequest(this.getURL(TWITTER_API_URL_SERVICE_ACCOUNT_VERIFY_CREDENTIALS));
        }
        try {
            HttpResponse resp = req.send();
            if (resp.getCode() == 200) {
                if (this.credential.hasXAuthCredentials()) {
                    this.token = Token.parse(resp.getBodyContent());
                }
                this.verified = true;
                this.saveSelfOnPool();
            } else if (resp.getCode() == 401) {
                this.verified = false;
            } else {
                HttpResponseCodeInterpreter.perform(resp);
            }
        }
        finally {
            req.close();
        }
        return this.verified;
    }

    public synchronized void signOut() throws IOException, LimitExceededException {
        this.checkValid();
        if (this.verified) {
            this.verified = false;
            this.token = null;
            this.signer = null;
            userAccountMngrPoll.remove(this.credential);
            Timeline.cleanPool();
            TweetER.cleanPool();
            FriendshipManager.cleanPool();
            this.invalidated = true;
        }
    }

    public UserAccount getUserAccount() throws IOException, LimitExceededException {
        return this.getUserAccount(new UserAccount(this.credential.getString("CREDENTIAL_USERNAME")));
    }

    public UserAccount getUserAccount(UserAccount user) throws IOException, LimitExceededException {
        this.checkValid();
        this.checkVerified();
        if (user == null) {
            throw new IllegalArgumentException("User must not be null.");
        }
        user.validateUserNameOrID();
        String[] pv = user.getUserNameOrIDParamValue();
        String param = "?" + pv[0] + "=" + pv[1];
        HttpRequest req = this.createRequest(this.getURL(TWITTER_API_URL_SERVICE_USERS_SHOW) + param);
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getDefaultParser();
            AccountHandler handler = new AccountHandler();
            parser.parse(resp.getStream(), handler);
            handler.loadParsedUserAccount(user);
            UserAccount userAccount = user;
            return userAccount;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    public UserAccount follow(UserAccount ua) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).follow(ua);
    }

    public UserAccount unfollow(UserAccount ua) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).unfollow(ua);
    }

    public boolean isFollowing(UserAccount ua) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).isFollowing(ua);
    }

    public UserAccount block(UserAccount ua) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).block(ua);
    }

    public UserAccount unblock(UserAccount ua) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).unblock(ua);
    }

    public boolean isBlocking(UserAccount ua) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).isBlocking(ua);
    }

    public String[] getFriendsID(Query query) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).getFriendsID(query);
    }

    public String[] getFollowersID(Query query) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).getFollowersID(query);
    }

    public UserAccount updateProfile(UserAccount newUserInfo) throws IOException, LimitExceededException {
        this.checkValid();
        this.checkVerified();
        if (newUserInfo == null) {
            throw new IllegalArgumentException("New user info must not be null.");
        }
        HttpRequest req = this.createRequest(this.getURL(TWITTER_API_URL_SERVICE_ACCOUNT_UPDATE_PROFILE));
        req.setMethod("POST");
        String info = newUserInfo.getString("USERACCOUNT_NAME");
        if (!StringUtil.isEmpty(info)) {
            req.setBodyParameter("name", info);
        }
        if (!StringUtil.isEmpty(info = newUserInfo.getString("USERACCOUNT_DESCRIPTION"))) {
            int MAX_LEN = 156;
            if (info.trim().length() > 156) {
                throw new IllegalArgumentException("Description must not be longer than 156 characters.");
            }
            req.setBodyParameter("description", info);
        }
        if (!StringUtil.isEmpty(info = newUserInfo.getString("USERACCOUNT_URL"))) {
            req.setBodyParameter("url", info);
        }
        if (!StringUtil.isEmpty(info = newUserInfo.getString("USERACCOUNT_LOCATION"))) {
            req.setBodyParameter("location", info);
        }
        if (req.getBodyParameters().size() == 0) {
            throw new IllegalArgumentException("New user info must not be empty.");
        }
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getDefaultParser();
            AccountHandler handler = new AccountHandler();
            parser.parse(resp.getStream(), handler);
            handler.loadParsedUserAccount(newUserInfo);
            UserAccount userAccount = newUserInfo;
            return userAccount;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof UserAccountManager)) {
            return false;
        }
        return this.credential.equals(((UserAccountManager)o).credential);
    }

    public int hashCode() {
        return this.credential.hashCode();
    }

    Credential getCredential() {
        return this.credential;
    }

    synchronized HttpRequest createRequest(String url) {
        HttpRequest req = new HttpRequest(url);
        if (this.credential.hasXAuthCredentials()) {
            if (this.token != null) {
                req.setSigner(this.signer, this.token);
            }
        } else {
            try {
                String crdntls = this.credential.getBasicHttpAuthCredential();
                crdntls = Base64Encoder.encode(crdntls.getBytes("UTF-8"));
                req.setHeaderField("Authorization", "Basic " + crdntls);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Invalid UTF-8 credentials.");
            }
        }
        return req;
    }

    private synchronized void checkValid() {
        if (this.invalidated) {
            throw new IllegalStateException("This instance is no longer valid. Get a new one!");
        }
    }

    private void checkVerified() {
        if (!this.verified) {
            throw new SecurityException("User's credentials have not been verified yet.");
        }
    }

    private synchronized void saveSelfOnPool() {
        if (userAccountMngrPoll.get(this.credential) == null) {
            userAccountMngrPoll.put(this.credential, this);
        }
    }

    static {
        SERVICES_URL = new Hashtable(10);
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_ACCOUNT_VERIFY_CREDENTIALS, "http://api.twitter.com/1/account/verify_credentials.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_OAUTH_ACCESS_TOKEN, "http://api.twitter.com/oauth/access_token");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_ACCOUNT_RATE_LIMIT_STATUS, "http://api.twitter.com/1/account/rate_limit_status.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_USERS_SHOW, "http://api.twitter.com/1/users/show.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_ACCOUNT_UPDATE_PROFILE, "http://api.twitter.com/1/account/update_profile.xml");
    }
}

