/*
 * Decompiled with CFR 0.152.
 */
package app.module.network.classes;

import app.models.Timeline;
import app.models.Tweet;
import com.twitterapime.rest.UserAccountManager;
import com.twitterapime.search.Query;
import com.twitterapime.search.QueryComposer;
import com.twitterapime.search.SearchDeviceListener;

public class TimelineHome
implements Timeline,
SearchDeviceListener {
    protected String latestID;
    protected String oldestID;
    protected UserAccountManager manager;
    protected com.twitterapime.rest.Timeline timeline;
    protected Tweet resultBuffer;
    protected Object lock;

    protected TimelineHome() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelineHome(UserAccountManager manager) {
        Object object = this.lock = new Object();
        synchronized (object) {
            this.timeline = com.twitterapime.rest.Timeline.getInstance(manager);
            Query q = QueryComposer.count(1);
            this.timeline.startGetHomeTweets(q, this);
            try {
                this.lock.wait();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (this.resultBuffer == null) {
                return;
            }
            String initialTweetID = this.resultBuffer.getID();
            this.latestID = String.valueOf(Long.parseLong(initialTweetID) - 1L);
            this.oldestID = String.valueOf(Long.parseLong(initialTweetID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Tweet goForward() {
        Object object = this.lock;
        synchronized (object) {
            Query q = QueryComposer.count(1);
            String currentMaxID = String.valueOf(Long.parseLong(this.latestID));
            q = QueryComposer.append(q, QueryComposer.sinceID(currentMaxID));
            this.timeline.startGetHomeTweets(q, this);
            try {
                this.lock.wait();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (this.resultBuffer == null) {
                return null;
            }
            this.latestID = this.resultBuffer.getID();
            return this.resultBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Tweet goBack() {
        Object object = this.lock;
        synchronized (object) {
            Query q = QueryComposer.count(1);
            String maxID = String.valueOf(Long.parseLong(this.oldestID) - 1L);
            q = QueryComposer.append(q, QueryComposer.maxID(maxID));
            this.timeline.startGetHomeTweets(q, this);
            try {
                this.lock.wait();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (this.resultBuffer == null) {
                return null;
            }
            this.oldestID = this.resultBuffer.getID();
            return this.resultBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tweetFound(com.twitterapime.search.Tweet tweet) {
        Object object = this.lock;
        synchronized (object) {
            String author = tweet.getUserAccount().getString("USERACCOUNT_USER_NAME");
            this.resultBuffer = new Tweet(author, tweet.getString("TWEET_CONTENT"), tweet.getString("TWEET_ID"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchCompleted() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchFailed(Throwable cause) {
        Object object = this.lock;
        synchronized (object) {
            System.out.println(cause.getMessage());
            this.resultBuffer = null;
            this.lock.notifyAll();
        }
    }
}

