/*
 * Decompiled with CFR 0.152.
 */
package app.module.L10n.classes;

import app.module.ui.helpers.UITextHelper;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;

public class Locale {
    protected static Hashtable keyValuePairs = new Hashtable();
    static /* synthetic */ Class class$app$module$L10n$classes$Locale;

    public static String getDeviceLocale() {
        return System.getProperty("microedition.locale");
    }

    public static String getLocaleFile(String locale) {
        if (locale == null) {
            return Locale.getLocaleFile(Locale.getDeviceLocale());
        }
        return "/app/files/L10n/" + locale + ".bin";
    }

    public static boolean loadFromFileBasedOnPreferences(String specifiedUserLocale, String defaultLocale) {
        return Locale.loadFromInternalFile(Locale.getLocaleFile(specifiedUserLocale)) || Locale.loadFromInternalFile(Locale.getLocaleFile(Locale.getDeviceLocale())) || Locale.loadFromInternalFile(Locale.getLocaleFile(defaultLocale));
    }

    public static boolean loadFromInternalFile(String internalFile) {
        try {
            InputStream stream = (class$app$module$L10n$classes$Locale == null ? (class$app$module$L10n$classes$Locale = Locale.class$("app.module.L10n.classes.Locale")) : class$app$module$L10n$classes$Locale).getResourceAsStream(internalFile);
            if (stream == null) {
                return false;
            }
            DataInputStream in = new DataInputStream(stream);
            if (in.available() == 0) {
                return false;
            }
            return Locale.loadFromDataInputStream(in);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean loadFromByteArray(byte[] data, int offset, int length) {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data, offset, length));
        return Locale.loadFromDataInputStream(in);
    }

    public static boolean loadFromDataInputStream(DataInputStream in) {
        try {
            while (true) {
                String key = in.readUTF();
                String value = in.readUTF();
                keyValuePairs.put(key, value);
            }
        }
        catch (EOFException ex) {
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static String get(String key) {
        return (String)keyValuePairs.get(key);
    }

    public static String get(String key, int value) {
        return Locale.get(key, String.valueOf(value));
    }

    public static String get(String key, String parameter) {
        String originalStr = Locale.get(key + ":" + parameter);
        if (originalStr == null) {
            originalStr = Locale.get(key);
        }
        if (originalStr == null) {
            return null;
        }
        int placeholderPosition = originalStr.indexOf("{@}");
        if (placeholderPosition == -1) {
            return originalStr;
        }
        return originalStr.substring(0, placeholderPosition) + parameter + originalStr.substring(placeholderPosition + 3);
    }

    public static void clear() {
        keyValuePairs.clear();
    }

    public static String formatDate(String dateFormat, Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        String day = String.valueOf(c.get(5));
        String result = UITextHelper.strReplace("d", day, dateFormat);
        String month = String.valueOf(c.get(2));
        result = UITextHelper.strReplace("m", month, result);
        String year = String.valueOf(c.get(1));
        result = UITextHelper.strReplace("y", year, result);
        int dayOfWeek = c.get(7);
        int dayOfWeekIndex = 0;
        switch (dayOfWeek) {
            case 2: {
                dayOfWeekIndex = 1;
                break;
            }
            case 3: {
                dayOfWeekIndex = 2;
                break;
            }
            case 4: {
                dayOfWeekIndex = 3;
                break;
            }
            case 5: {
                dayOfWeekIndex = 4;
                break;
            }
            case 6: {
                dayOfWeekIndex = 5;
                break;
            }
            case 7: {
                dayOfWeekIndex = 6;
                break;
            }
            case 1: {
                dayOfWeekIndex = 7;
                break;
            }
            default: {
                dayOfWeekIndex = 0;
            }
        }
        result = UITextHelper.strReplace("D", Locale.get("weekdays.names", dayOfWeekIndex), result);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

