/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest;

import com.twitterapime.io.HttpRequest;
import com.twitterapime.io.HttpResponse;
import com.twitterapime.io.HttpResponseCodeInterpreter;
import com.twitterapime.parser.DefaultXMLHandler;
import com.twitterapime.parser.Parser;
import com.twitterapime.parser.ParserException;
import com.twitterapime.parser.ParserFactory;
import com.twitterapime.rest.Credential;
import com.twitterapime.rest.UserAccount;
import com.twitterapime.rest.UserAccountManager;
import com.twitterapime.rest.handler.AccountHandler;
import com.twitterapime.search.InvalidQueryException;
import com.twitterapime.search.LimitExceededException;
import com.twitterapime.search.Query;
import com.twitterapime.util.StringUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class FriendshipManager {
    private static final Hashtable SERVICES_URL = new Hashtable(4);
    private static Hashtable friendsMngrPool;
    private static FriendshipManager singleInstance;
    public static final String TWITTER_API_URL_SERVICE_FRIENDS_ID = "TWITTER_API_URL_SERVICE_FRIENDS_ID";
    public static final String TWITTER_API_URL_SERVICE_FOLLOWERS_ID = "TWITTER_API_URL_SERVICE_FOLLOWERS_ID";
    public static final String TWITTER_API_URL_SERVICE_FRIENDSHIPS_CREATE = "TWITTER_API_URL_SERVICE_FRIENDSHIPS_CREATE";
    public static final String TWITTER_API_URL_SERVICE_FRIENDSHIPS_DESTROY = "TWITTER_API_URL_SERVICE_FRIENDSHIPS_DESTROY";
    public static final String TWITTER_API_URL_SERVICE_FRIENDSHIPS_EXISTS = "TWITTER_API_URL_SERVICE_FRIENDSHIPS_EXISTS";
    public static final String TWITTER_API_URL_SERVICE_BLOCKS_CREATE = "TWITTER_API_URL_SERVICE_BLOCKS_CREATE";
    public static final String TWITTER_API_URL_SERVICE_BLOCKS_DESTROY = "TWITTER_API_URL_SERVICE_BLOCKS_DESTROY";
    public static final String TWITTER_API_URL_SERVICE_BLOCKS_EXISTS = "TWITTER_API_URL_SERVICE_BLOCKS_EXISTS";
    private UserAccountManager userAccountMngr;

    private String getURL(String serviceKey) {
        return (String)SERVICES_URL.get(serviceKey);
    }

    static synchronized void cleanPool() {
        if (friendsMngrPool != null) {
            Enumeration keys = friendsMngrPool.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                FriendshipManager value = (FriendshipManager)friendsMngrPool.get(key);
                if (value.userAccountMngr.isVerified()) continue;
                friendsMngrPool.remove(key);
            }
        }
    }

    public void setServiceURL(String serviceKey, String url) {
        SERVICES_URL.put(serviceKey, url);
    }

    public static synchronized FriendshipManager getInstance(UserAccountManager uam) {
        FriendshipManager fsmr;
        if (uam == null) {
            throw new IllegalArgumentException("UserAccountManager must not be null.");
        }
        if (!uam.isVerified()) {
            throw new SecurityException("User's credential must be verified.");
        }
        if (friendsMngrPool == null) {
            friendsMngrPool = new Hashtable();
        }
        if ((fsmr = (FriendshipManager)friendsMngrPool.get(uam)) == null) {
            fsmr = new FriendshipManager(uam);
            friendsMngrPool.put(uam, fsmr);
        }
        return fsmr;
    }

    public static synchronized FriendshipManager getInstance() {
        if (singleInstance == null) {
            singleInstance = new FriendshipManager();
        }
        return singleInstance;
    }

    private FriendshipManager() {
    }

    private FriendshipManager(UserAccountManager uam) {
        this.userAccountMngr = uam;
    }

    public String[] getFriendsID(Query query) throws IOException, LimitExceededException {
        this.checkUserAuth();
        return this.retrieveIDs(this.getURL(TWITTER_API_URL_SERVICE_FRIENDS_ID), this.userAccountMngr.getUserAccount(), query);
    }

    public String[] getFriendsID(UserAccount user, Query query) throws IOException, LimitExceededException {
        return this.retrieveIDs(this.getURL(TWITTER_API_URL_SERVICE_FRIENDS_ID), user, query);
    }

    public String[] getFollowersID(Query query) throws IOException, LimitExceededException {
        this.checkUserAuth();
        return this.retrieveIDs(this.getURL(TWITTER_API_URL_SERVICE_FOLLOWERS_ID), this.userAccountMngr.getUserAccount(), query);
    }

    public String[] getFollowersID(UserAccount user, Query query) throws IOException, LimitExceededException {
        return this.retrieveIDs(this.getURL(TWITTER_API_URL_SERVICE_FOLLOWERS_ID), user, query);
    }

    public UserAccount follow(UserAccount ua) throws IOException, LimitExceededException {
        return this.manageFriendship(TWITTER_API_URL_SERVICE_FRIENDSHIPS_CREATE, ua);
    }

    public UserAccount unfollow(UserAccount ua) throws IOException, LimitExceededException {
        return this.manageFriendship(TWITTER_API_URL_SERVICE_FRIENDSHIPS_DESTROY, ua);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFollowing(UserAccount ua) throws IOException, LimitExceededException {
        if (ua == null) {
            throw new IllegalArgumentException("UserAccount object must not me null.");
        }
        ua.validateUserNameOrID();
        this.checkUserAuth();
        Credential c = this.userAccountMngr.getCredential();
        String qryStr = "?user_a=" + c.getString("CREDENTIAL_USERNAME") + "&user_b=" + ua.getUserNameOrID();
        HttpRequest req = this.userAccountMngr.createRequest(this.getURL(TWITTER_API_URL_SERVICE_FRIENDSHIPS_EXISTS) + qryStr);
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            boolean bl = resp.getBodyContent().toLowerCase().equals("true");
            return bl;
        }
        finally {
            req.close();
        }
    }

    public UserAccount block(UserAccount ua) throws IOException, LimitExceededException {
        return this.manageFriendship(TWITTER_API_URL_SERVICE_BLOCKS_CREATE, ua);
    }

    public UserAccount unblock(UserAccount ua) throws IOException, LimitExceededException {
        return this.manageFriendship(TWITTER_API_URL_SERVICE_BLOCKS_DESTROY, ua);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlocking(UserAccount ua) throws IOException, LimitExceededException {
        if (ua == null) {
            throw new IllegalArgumentException("UserAccount object must not me null.");
        }
        ua.validateUserNameOrID();
        this.checkUserAuth();
        HttpRequest req = this.userAccountMngr.createRequest(this.getURL(TWITTER_API_URL_SERVICE_BLOCKS_EXISTS) + ua.getUserNameOrID() + ".xml");
        try {
            HttpResponse resp = req.send();
            if (resp.getCode() == 404) {
                boolean bl = false;
                return bl;
            }
            HttpResponseCodeInterpreter.perform(resp);
            boolean bl = true;
            return bl;
        }
        finally {
            req.close();
        }
    }

    private UserAccount manageFriendship(String servURLKey, UserAccount ua) throws IOException, LimitExceededException {
        if (ua == null) {
            throw new IllegalArgumentException("UserAccount object must not me null.");
        }
        ua.validateUserNameOrID();
        this.checkUserAuth();
        String[] pv = ua.getUserNameOrIDParamValue();
        HttpRequest req = this.userAccountMngr.createRequest(this.getURL(servURLKey));
        req.setMethod("POST");
        req.setBodyParameter(pv[0], pv[1]);
        try {
            HttpResponse resp = req.send();
            if (resp.getCode() == 403) {
                throw new InvalidQueryException(HttpResponseCodeInterpreter.getErrorMessage(resp));
            }
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getDefaultParser();
            AccountHandler handler = new AccountHandler();
            parser.parse(resp.getStream(), handler);
            UserAccount userAccount = handler.getParsedUserAccount();
            return userAccount;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    private String[] retrieveIDs(String url, UserAccount user, Query query) throws IOException, LimitExceededException {
        if (user == null) {
            throw new IllegalArgumentException("User must not be null.");
        }
        user.validateUserNameOrID();
        String[] pv = user.getUserNameOrIDParamValue();
        url = url + "?" + pv[0] + "=" + pv[1];
        long maxCount = Long.MAX_VALUE;
        if (query != null) {
            maxCount = Long.parseLong(StringUtil.split(query.toString(), '=')[1]);
        }
        long loadedCount = 0L;
        long cursorNextIdx = -1L;
        Vector idsList = new Vector(20);
        IDsHandler handler = new IDsHandler(maxCount);
        Parser parser = ParserFactory.getDefaultParser();
        do {
            HttpRequest req = this.userAccountMngr != null ? this.userAccountMngr.createRequest(url + "&cursor=" + cursorNextIdx) : new HttpRequest(url + "&cursor=" + cursorNextIdx);
            try {
                HttpResponse resp = req.send();
                HttpResponseCodeInterpreter.perform(resp);
                parser.parse(resp.getStream(), handler);
                cursorNextIdx = handler.getCursorNextIndex();
                handler.clear();
            }
            catch (ParserException e) {
                throw new IOException(e.getMessage());
            }
            finally {
                req.close();
            }
        } while ((loadedCount += (long)this.copyVector(idsList, handler.getIDsList())) < maxCount && cursorNextIdx != 0L);
        Object[] ids = new String[idsList.size()];
        idsList.copyInto(ids);
        return ids;
    }

    private int copyVector(Vector to, Vector from) {
        int size = from.size();
        for (int i = 0; i < size; ++i) {
            to.addElement(from.elementAt(i));
        }
        return size;
    }

    private void checkUserAuth() {
        if (this.userAccountMngr == null || !this.userAccountMngr.isVerified()) {
            throw new SecurityException("User's credential must be entered to perform this operation.");
        }
    }

    static {
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_FRIENDS_ID, "http://api.twitter.com/1/friends/ids.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_FOLLOWERS_ID, "http://api.twitter.com/1/followers/ids.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_FRIENDSHIPS_CREATE, "http://api.twitter.com/1/friendships/create.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_FRIENDSHIPS_DESTROY, "http://api.twitter.com/1/friendships/destroy.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_FRIENDSHIPS_EXISTS, "http://api.twitter.com/1/friendships/exists.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_BLOCKS_CREATE, "http://api.twitter.com/1/blocks/create.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_BLOCKS_DESTROY, "http://api.twitter.com/1/blocks/destroy.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_BLOCKS_EXISTS, "http://api.twitter.com/1/blocks/exists/");
    }

    private static class IDsHandler
    extends DefaultXMLHandler {
        private final long maxCount;
        private long count;
        private long cursorNextIdx;
        private Vector idsList = new Vector(20);

        public IDsHandler(long maxCount) {
            this.maxCount = maxCount;
        }

        public void text(String text) throws ParserException {
            text = text.trim();
            if (this.xmlPath.equals("/id_list/ids/id")) {
                if (this.count < this.maxCount) {
                    this.idsList.addElement(text);
                    ++this.count;
                }
            } else if (this.xmlPath.equals("/id_list/next_cursor")) {
                this.cursorNextIdx = Long.parseLong(text);
            }
        }

        public Vector getIDsList() {
            return this.idsList;
        }

        public long getCursorNextIndex() {
            return this.cursorNextIdx;
        }

        public void clear() {
            this.idsList.removeAllElements();
            this.cursorNextIdx = 0L;
        }
    }
}

