/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.parser;

import com.twitterapime.parser.Parser;
import com.twitterapime.platform.PlatformProviderSelector;

public final class ParserFactory {
    public static Parser getDefaultParser() {
        String JAVA_ME_PARSER_IMPL_CLASS = "impl.javame.com.twitterapime.parser.KXML2Parser";
        String ANDROID_PARSER_IMPL_CLASS = "impl.android.com.twitterapime.parser.SAXParser";
        long PPID = PlatformProviderSelector.getCurrentProvider().getID();
        if (PPID == 1L) {
            return ParserFactory.newInstance("impl.javame.com.twitterapime.parser.KXML2Parser");
        }
        if (PPID == 2L) {
            return ParserFactory.newInstance("impl.android.com.twitterapime.parser.SAXParser");
        }
        throw new IllegalArgumentException("Unknown platform ID: " + PPID);
    }

    private static Parser newInstance(String className) {
        try {
            return (Parser)Class.forName(className).newInstance();
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException e) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private ParserFactory() {
    }
}

