/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.io;

import com.twitterapime.io.HttpConnection;
import com.twitterapime.platform.PlatformProviderSelector;
import java.io.IOException;

public final class HttpConnector {
    private static final HttpConnection newInstance(String className) {
        try {
            return (HttpConnection)Class.forName(className).newInstance();
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException e) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static HttpConnection open(String url) throws IOException {
        if (url == null || url.trim().length() == 0) {
            throw new IllegalArgumentException("URL must not be null/empty.");
        }
        String JAVA_ME_HTTP_IMPL_CLASS = "impl.javame.com.twitterapime.io.HttpConnectionImpl";
        String JAVA_ME_HTTP_USER_AGENT = "Twitter API ME/1.4 (compatible; Java ME; MIDP-2.0; CLDC-1.0)";
        String ANDROID_HTTP_IMPL_CLASS = "impl.android.com.twitterapime.io.HttpConnectionImpl";
        String ANDROID_HTTP_USER_AGENT = "Twitter API ME/1.4 (compatible; Android 1.1)";
        long PPID = PlatformProviderSelector.getCurrentProvider().getID();
        HttpConnection conn = null;
        String userAgent = null;
        if (PPID == 1L) {
            conn = HttpConnector.newInstance("impl.javame.com.twitterapime.io.HttpConnectionImpl");
            userAgent = "Twitter API ME/1.4 (compatible; Java ME; MIDP-2.0; CLDC-1.0)";
        } else if (PPID == 2L) {
            conn = HttpConnector.newInstance("impl.android.com.twitterapime.io.HttpConnectionImpl");
            userAgent = "Twitter API ME/1.4 (compatible; Android 1.1)";
        } else {
            throw new IllegalArgumentException("Unknown platform ID: " + PPID);
        }
        conn.open(url);
        conn.setRequestProperty("User-Agent", userAgent);
        return conn;
    }

    private HttpConnector() {
    }
}

