/*
 * Decompiled with CFR 0.152.
 */
package app.module.ui.classes;

import app.module.ui.helpers.ClipHelper;
import app.module.ui.helpers.KeyHelper;
import app.module.ui.helpers.UITextHelper;
import app.module.ui.models.BaseWidget;
import app.module.ui.models.CallbackHandler;
import app.module.ui.models.UITheme;
import com.apress.framework.objecttypes.Event;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class StringItem
extends BaseWidget {
    protected String[] linesSelected;
    protected String[] linesNotSelected;
    protected String realString;
    protected int maxHeight;
    protected int maxWidth;
    protected UITheme theme;
    protected int PADDING = 5;
    protected CallbackHandler handler;

    public StringItem(String string, int maxLineWidth, int maxTextHeight, CallbackHandler handler, UITheme theme) {
        this.maxHeight = maxTextHeight;
        this.maxWidth = maxLineWidth;
        this.theme = theme;
        this.handler = handler;
        this.setText(string);
    }

    public void setText(String text) {
        this.linesSelected = UITextHelper.wrapText(text, this.maxWidth, this.maxHeight, this.theme.getSelectedFont());
        this.linesNotSelected = UITextHelper.wrapText(text, this.maxWidth, this.theme.getNotSelectedFont().getHeight() * 2, this.theme.getNotSelectedFont());
        this.realString = text;
    }

    public String getText() {
        return this.realString;
    }

    public void paint(Graphics g) {
        ClipHelper.setClipOn(this, g);
        int bgColor = this.theme.getNotSelectedBgColor();
        int fgColor = this.theme.getNotSelectedFgColor();
        String[] text = this.linesNotSelected;
        Font f = this.theme.getNotSelectedFont();
        if (this.isFocused()) {
            bgColor = this.theme.getSelectedBgColor();
            fgColor = this.theme.getSelectedFgColor();
            f = this.theme.getSelectedFont();
            text = this.linesSelected;
        }
        g.setColor(bgColor);
        g.fillRect(this.getAbsoluteX(), this.getAbsoluteY(), this.getTotalWidth(), this.getTotalHeight());
        g.setColor(fgColor);
        g.setFont(f);
        int i = 0;
        for (i = 0; i < text.length; ++i) {
            g.drawString(text[i], this.getAbsoluteX() + this.PADDING, this.getAbsoluteY() + this.PADDING + f.getHeight() * i, 20);
        }
        ClipHelper.resetClip(g);
    }

    public boolean onFocus() {
        super.onFocus();
        if (this.getParent() != null) {
            this.getParent().doLayout();
        }
        return true;
    }

    public boolean onLostFocus() {
        super.onLostFocus();
        if (this.getParent() != null) {
            this.getParent().doLayout();
        }
        return false;
    }

    public int getPreferredContentHeight() {
        Font font = this.theme.getNotSelectedFont();
        String[] text = this.linesNotSelected;
        if (this.isFocused()) {
            font = this.theme.getSelectedFont();
            text = this.linesSelected;
        }
        return this.PADDING * 2 + text.length * font.getHeight();
    }

    public int getPreferredContentWidth() {
        return this.maxWidth + this.PADDING * 2;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean handleKeyReleased(int key) {
        if (8 == KeyHelper.getGameAction(key)) {
            this.fireEvent();
            return true;
        }
        return false;
    }

    public boolean handlePointerReleased(int x, int y) {
        super.handlePointerReleased(x, y);
        this.fireEvent();
        return true;
    }

    protected void fireEvent() {
        if (this.handler != null) {
            Event event = new Event(4, 40001, this);
            this.handler.doCallback(event);
        }
    }
}

