/*
 * Decompiled with CFR 0.152.
 */
package app.module.ui.classes;

import app.module.ui.helpers.KeyHelper;
import app.module.ui.models.BaseContainerManager;
import app.module.ui.models.UITheme;
import app.module.ui.models.Widget;

public class HorizontalContainer
extends BaseContainerManager {
    protected int PADDING = 3;

    public HorizontalContainer(UITheme theme) {
        super(theme);
    }

    public void doLayout() {
        int currentX = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Widget temp = this.getWidget(i);
            temp.setY(0);
            temp.setX(currentX);
            currentX += temp.getTotalWidth() + this.PADDING;
        }
        this.requestRepaint();
    }

    public boolean handleKeyReleased(int key) {
        if (this.getFocusedWidget().handleKeyReleased(key)) {
            return true;
        }
        if (2 == KeyHelper.getGameAction(key)) {
            int max = this.indexOf(this.getFocusedWidget());
            for (int i = max - 1; i >= 0; --i) {
                if (!this.getWidget(i).isFocusable()) continue;
                this.focusWidget(this.getWidget(i));
                return true;
            }
            return false;
        }
        if (5 == KeyHelper.getGameAction(key)) {
            int min = this.indexOf(this.getFocusedWidget());
            int max = this.getChildCount();
            for (int i = min + 1; i < max; ++i) {
                if (!this.getWidget(i).isFocusable()) continue;
                this.focusWidget(this.getWidget(i));
                return true;
            }
            return false;
        }
        return false;
    }

    public int getPreferredContentHeight() {
        int maxH = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int tempH = this.getWidget(i).getTotalHeight();
            if (tempH <= maxH) continue;
            maxH = tempH;
        }
        return maxH;
    }

    public int getPreferredContentWidth() {
        int maxW = 0;
        if (this.getChildCount() > 0) {
            Widget lastWidget = this.getWidget(this.getChildCount() - 1);
            maxW = lastWidget.getX() + lastWidget.getTotalWidth();
        }
        return maxW;
    }

    public boolean handlePointerDragged(int x, int y) {
        if (super.handlePointerDragged(x, y)) {
            return true;
        }
        int deltaX = this.getOldX() - x;
        this.setOldY(y);
        this.setOldX(x);
        int scroll = this.getXScroll() + deltaX;
        int maxScroll = Math.max(this.getPreferredContentWidth() - this.getContentWidth(), 0);
        if (scroll >= 0 && scroll <= maxScroll) {
            this.setXScroll(scroll);
            this.requestRepaint();
        }
        return true;
    }
}

