/*
 * Decompiled with CFR 0.152.
 */
package app.module.persistence.helpers;

import app.module.persistence.classes.PersistenceProvider;
import app.module.persistence.classes.RecordReader;
import app.module.persistence.classes.RecordWriter;
import app.module.persistence.models.ByteRecordReader;
import app.module.persistence.models.ByteRecordWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class TOC {
    Hashtable TOCHashtable = new Hashtable();
    PersistenceProvider provider;
    RecordReader reader;
    RecordWriter writer = new ByteRecordWriter();

    public TOC(PersistenceProvider provider) {
        this.provider = provider;
        provider.open();
        if (provider.getRecord(1) == null) {
            this.save();
            return;
        }
        this.reader = new ByteRecordReader(provider.getRecord(1));
        for (int size = this.reader.readInt(); size > 0; --size) {
            String key = this.reader.readString();
            int value = this.reader.readInt();
            this.addEntry(key, value);
        }
    }

    protected byte[] getCurrentTOCBytes() {
        int size = this.TOCHashtable.size();
        this.writer.reset();
        this.writer.writeInt(size);
        Enumeration keys = this.TOCHashtable.keys();
        while (keys.hasMoreElements()) {
            String tempKey = (String)keys.nextElement();
            this.writer.writeString(tempKey);
            this.writer.writeInt((Integer)this.TOCHashtable.get(tempKey));
        }
        return this.writer.getCurrentResult();
    }

    public void save() {
        if (this.provider.getRecord(1) == null) {
            this.provider.createRecord(new byte[]{0});
        }
        System.out.println("SAVE TOC");
        this.provider.overwriteRecord(1, this.getCurrentTOCBytes());
    }

    public void addEntry(String key, int index) {
        this.TOCHashtable.put(key, new Integer(index));
    }

    public void deleteEntry(String key) {
        this.TOCHashtable.remove(key);
    }

    public int getIndexFor(String key) {
        Integer result = (Integer)this.TOCHashtable.get(key);
        if (result != null) {
            return result;
        }
        return -1;
    }
}

