'use strict';

var repeat = require('repeat-string');

module.exports = function padLeft(val, num, str) {
  var padding = '';
  var diff = num - val.length;

  // Breakpoints based on benchmarks to use the fastest approach
  // for the given number of zeros
  if (diff <= 5 && !str) {
    padding = '00000';
  } else if (diff <= 25 && !str) {
    padding = '000000000000000000000000000';
  } else {
    return val + repeat(str || '0', diff);
  }

  return val + padding.slice(0, diff);
};
