package rozdzial25;

import javafx.application.Application;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class Listing25_14 extends Application {

    private GraphicsContext gc;
    private double width;
    private double height;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Group root = new Group();
            Canvas canvas = new Canvas(300, 300);
            gc = canvas.getGraphicsContext2D();
            width = canvas.getWidth();
            height = canvas.getHeight();
            double n = 7;
            double d = 9;
            rozeta_grandiego(100.0, n / d, 3400, Color.GREEN);
            root.getChildren().add(canvas);
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void rozeta_grandiego(double a, double k, int liczbaPunktow,
                                 Paint strokeStyle) {
        gc.save();
        gc.beginPath();
        gc.setStroke(strokeStyle);
        gc.translate(width / 2, height / 2);
        double x1 = a;
        double y1 = 0;
        double x2;
        double y2;
        for (int i = 0; i < liczbaPunktow; i++) {
            double t = i * Math.PI / 360;
            x2 = a * Math.cos(k * t) * Math.cos(t);
            y2 = a * Math.cos(k * t) * Math.sin(t);
            gc.moveTo(x1, y1);
            gc.lineTo(x2, y2);
            x1 = x2;
            y1 = y2;
        }
        gc.stroke();
        gc.restore();
    }
}
