package rozdzial24;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class Listing24_10 extends Application {
    BufferedInputStream bis;
    FileInputStream is;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            is = new FileInputStream(new File("src/rozdzial24/kwiatek3.jpg"));
            bis = new BufferedInputStream(is);
            Image image = new Image(bis);
            ImageView imageView = new ImageView(image);
            StackPane root = new StackPane();
            root.getChildren().add(imageView);
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.show();
            PixelReader pr = image.getPixelReader();
            int argb = pr.getArgb(100, 100);
            System.out.println(argb);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        if (bis != null) {
            try {
                bis.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (is != null) {
            try {
                is.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
