package rozdzial22;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.TextFieldTreeCell;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class Listing22_29 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void init() {
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            TreeItem<String> troot = Systematyka.wstawDane();
            TreeView<String> syst = new TreeView<>();
            syst.setEditable(true);
            syst.setCellFactory(TextFieldTreeCell.forTreeView());
            syst.setOnEditStart(event -> {
                String d1 = event.getOldValue();
                System.out.println("Chcesz zmienić wartość " + d1);
            });
            syst.setOnEditCommit(event -> {
                String d1 = event.getOldValue();
                String d2 = event.getNewValue();
                System.out
                        .println("Zamieniłeś wartość " + d1 + " na " + d2);
            });
            syst.setOnEditCancel(event -> System.out.println("Nie zmieniłeś wartości"));
            syst.setRoot(troot);
            syst.setPrefHeight(500);
            root.getChildren().add(syst);
            Scene scene = new Scene(root, 400, 500);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
    }
}
