package rozdzial13;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.effect.Reflection;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class Listing13_09 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Pane root = new Pane();
            Text text = new Text("Jacek");
            text.setX(260);
            text.setY(100);
            text.setFill(Color.AQUAMARINE);
            text.setFont(Font.font(null, FontWeight.BOLD, 80));
            //efekt
            Reflection ds = new Reflection();
            text.setEffect(ds);
            //slider 1
            Slider oxslider = new Slider(0, 50, 0);
            oxslider.setLayoutX(80);
            oxslider.setLayoutY(20);
            oxslider.setMajorTickUnit(10);
            oxslider.setShowTickLabels(true);
            oxslider.setShowTickMarks(true);
            ds.topOffsetProperty().bind(oxslider.valueProperty());
            Label oxslabel = new Label("topOffset: ");
            oxslabel.setLabelFor(oxslider);
            oxslabel.setLayoutX(20);
            oxslabel.setLayoutY(20);
            //slider 2
            Slider oyslider = new Slider(0.0, 1.0, 0.75);
            oyslider.setLayoutX(80);
            oyslider.setLayoutY(60);
            oyslider.setMajorTickUnit(0.1);
            oyslider.setShowTickLabels(true);
            oyslider.setShowTickMarks(true);
            ds.fractionProperty().bind(oyslider.valueProperty());
            Label oyslabel = new Label("fraction: ");
            oyslabel.setLabelFor(oyslider);
            oyslabel.setLayoutX(20);
            oyslabel.setLayoutY(60);
            //slider 3
            Slider cslider = new Slider(0.0, 1.0, 0.5);
            cslider.setLayoutX(80);
            cslider.setLayoutY(100);
            cslider.setMajorTickUnit(0.1);
            cslider.setShowTickLabels(true);
            cslider.setShowTickMarks(true);
            ds.topOpacityProperty().bind(cslider.valueProperty());
            Label slabel = new Label("topOpacity: ");
            slabel.setLabelFor(cslider);
            slabel.setLayoutX(20);
            slabel.setLayoutY(100);
            //slider 4
            Slider rslider = new Slider(0.0, 1.0, 0.0);
            rslider.setLayoutX(100);
            rslider.setLayoutY(140);
            rslider.setMajorTickUnit(0.1);
            rslider.setShowTickLabels(true);
            rslider.setShowTickMarks(true);
            ds.bottomOpacityProperty().bind(rslider.valueProperty());
            Label rlabel = new Label("bottomOpacity: ");
            rlabel.setLabelFor(rslider);
            rlabel.setLayoutX(20);
            rlabel.setLayoutY(140);
            root.getChildren().addAll(oxslabel, oxslider, oyslabel, oyslider,
                    cslider, slabel, rlabel, rslider, text);
            Scene scene = new Scene(root, 560, 280);
            stage.setScene(scene);
            stage.setTitle("Reflection");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
