package math.primes;

import math.utils.FiboUtil;

import javax.swing.*;
import java.awt.*;
import java.math.BigInteger;

public class BinaryFibo extends JFrame {
    private static final long serialVersionUID = 1L;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new BinaryFibo(Color.BLUE, 600));
    }

    public BinaryFibo(Color color, int max) {
        FiboPanel panel = new FiboPanel(color, max);
        setLayout(null);
        setPreferredSize(new Dimension(1000, 1000));
        int frameHeight = 1000;
        int frameWidth = 1000;
        setBounds(
                (Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (frameWidth / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (frameHeight / 2),
                frameWidth, frameHeight);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        setResizable(true);
        add(panel);
        setVisible(true);
    }
}

/**
 * kreslenie spirali Archimedesa;
 */
class FiboPanel extends JPanel {
    private static final long serialVersionUID = 4145929212344860830L;
    private final Color color;
    private final String[] fibos;

    public FiboPanel(Color color, int max) {
        this.color = color;
        setPreferredSize(new Dimension(1000, 1000));
        setBounds(0, 0, 1000, 1000);
        fibos = new String[max];
        BigInteger fibo;
        for (int i = 0; i < max; i++) {
            fibo = FiboUtil.fibonacci((long) i);
            fibos[i] = fibo.toString(2);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, 1000, 1000);
        g2.setColor(this.color);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < fibos.length; i++) {
            String fibo = fibos[i];
            int len = fibo.length();
            int pos = 1000 - len - 30;
            for (int j = 0; j < len; j++) {
                if (fibo.substring(j, j + 1).equals("1")) {
                    g2.fillRect(pos + j, i + 10, 1, 1);
                }
            }
        }
    }
}
