package math.kombi.examples;

import math.kombi.npok.Npok;

import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class NpokMain2 {
    public static void main(String[] args) {
        BigInteger n = new BigInteger("200");
        BigInteger k = new BigInteger("180");
        ExecutorService es = Executors.newFixedThreadPool(1);
        Future<BigInteger> f;
        System.out.println("Start");
        Instant startTime = Instant.now();
        f = es.submit(new Npok(n, k));
        try {
            System.out.println(f.get());
        } catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        es.shutdown();
        Instant endTime = Instant.now();
        long time = Duration.between(startTime, endTime).toMillis();
        System.out.println("Czas wykonania: " + time + (" ms"));
        System.out.println("Koniec");
    }
}
