package rozdzial24;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.image.*;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Listing24_19 extends Application {
    BufferedInputStream bis;
    FileInputStream is;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            is = new FileInputStream(new File("src/rozdzial24/kwiatek3.jpg"));
            bis = new BufferedInputStream(is);
            Image image = new Image(bis);
            ImageView imageView = new ImageView(image);
            PixelReader pr = image.getPixelReader();
            int x = 0;
            int y = 0;
            int w = (int) image.getWidth();
            int h = (int) image.getHeight();
            WritablePixelFormat<ByteBuffer> wpf1 = PixelFormat
                    .getByteBgraInstance();
            byte[] buffer = new byte[w * h * 4];
            int offset = 0;
            int scanlineStride = w * 4;
            pr.getPixels(x, y, w, h, wpf1, buffer, offset, scanlineStride);
            WritableImage image1 = new WritableImage(100, 100);
            PixelWriter pw = image1.getPixelWriter();
            pw.setPixels(x, y, 100, 100, wpf1, buffer, offset, scanlineStride);
            ImageView imageView1 = new ImageView(image1);
            HBox root = new HBox();
            root.getChildren().addAll(imageView, imageView1);
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        if (bis != null) {
            try {
                bis.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (is != null) {
            try {
                is.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
