package rozdzial11;

import javafx.application.Application;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.*;
import javafx.scene.transform.Translate;
import javafx.stage.Stage;

public class Listing11_04 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        boolean supp = Platform.isSupported(ConditionalFeature.SCENE3D);
        try {
            if (supp) {
                Group group = new Group();
                Sphere sphere = new Sphere(50);
                Translate trans1 = new Translate(100, 100, 0);
                sphere.setDrawMode(DrawMode.LINE);
                sphere.setCullFace(CullFace.NONE);
                sphere.getTransforms().add(trans1);
                Cylinder cyli = new Cylinder(30, 100);
                cyli.setDrawMode(DrawMode.LINE);
                cyli.setCullFace(CullFace.NONE);
                Translate trans3 = new Translate(250, 100, 0);
                cyli.getTransforms().add(trans3);
                Box box = new Box(100, 100, 100);
                Translate trans2 = new Translate(400, 100, 0);
                box.setDrawMode(DrawMode.LINE);
                box.setCullFace(CullFace.NONE);
                box.getTransforms().addAll(trans2);
                group.getChildren().addAll(sphere, box, cyli);
                Scene scene = new Scene(group, 500, 200, true,
                        SceneAntialiasing.BALANCED);
                stage.setScene(scene);
            } else {
                StackPane root = new StackPane();
                Label label = new Label("Brak obsługi 3D");
                root.getChildren().add(label);
                Scene sc = new Scene(root, 300, 200);
                stage.setScene(sc);
            }
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
