
package com.corejdo.examples.transactions;

import com.corejdo.examples.chapter4.model.Author;
import javax.jdo.*;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import java.sql.Connection;
import javax.sql.DataSource;
import javax.ejb.EJBException;
import java.util.Iterator;
import java.sql.PreparedStatement;

/**
 * @ejbHome <{com.corejdo.examples.transactions.AuthorHome}>
 * @ejbRemote <{com.corejdo.examples.transactions.AuthorEJB}>
 * @ejbStateful
 * @undefined
 * @displayName
 * @ejbTransactionAttribute Required
 */
public class AuthorBean implements javax.ejb.SessionBean {
    private javax.ejb.SessionContext ctx;
    private PersistenceManagerFactory pmf;
    private InitialContext ictx;

    /**
     * @RESOURCE-REF
     * @ResourceRefAuth Container
     * @ResourceRefType javax.sql.DataSource
     * @RES_JNDI_NAME AuthorXADataSource
     * @ResourceRefRemoteType remote
     * @undefined
     */
    static private String AuthorXADataSource = "AuthorXADataSource";

    public void setSessionContext(javax.ejb.SessionContext context) throws RemoteException, javax.ejb.EJBException {
        ctx = context;
        try {
            // Rzeczywiste aplikacje zwykle buforuj kontekst dla lepszej efektywnoci
            ictx = new InitialContext();
            pmf = (PersistenceManagerFactory)ictx.lookup("java:comp/env/jdo/authorsb");
            System.out.println("AuthorBean : Odnaleziono PMF jdo/authorsb");
        } catch (NamingException e) {
            System.out.println("AuthorBean : Wyjtek podczas odnajdywania PMF jdo/authorsb " + e);
            throw new EJBException(e);
        }
    }

    public void ejbActivate() throws javax.ejb.EJBException {
    }

    public void ejbPassivate() throws javax.ejb.EJBException {
    }

    public void ejbRemove() throws javax.ejb.EJBException {
    }

    public void ejbCreate() throws javax.ejb.CreateException, javax.ejb.EJBException {
        // Write your code here
    }

    /**
     * @input A vector of Author objects
     * @output The ISBN number
     */
    public boolean updateAuthors(Vector authors, String isbn) {
// initialize member variables
		Connection con=null;
	    String authornames="";
	    PreparedStatement ps =null;
		 PersistenceManager pm=null;

        // do some JDO work
        try {

          pm = pmf.getPersistenceManager();
            Iterator it = authors.iterator();
            while (it.hasNext()) {
                Author author = (Author)it.next();
                authornames += author.getName() + " , " ; // build the string for next part
                pm.makePersistent(author);
            }
            pm.close();
            // do some legacy work
            DataSource ds = (javax.sql.DataSource) ictx.lookup("AuthorXADataSource");
             con = ds.getConnection();
            ps = con.prepareStatement("update isbntable set authors = ? where isbn = ?");
            ps.setString(1, authornames);
            ps.setString(2, isbn);
            ps.executeUpdate();
            return true;
        } catch (Exception e) {
            System.out.println("An exception occured in the distributed tx " + e);
            // mark the distributed Tx for rollback only
            ctx.setRollbackOnly();
            return false;
        } finally {
            try{
            ps.close();
            con.close();
            pm.close();
            }catch(Exception e){} // do nothing here
        }
    }
}
