package com.corejdo.examples.chapter7;

import com.corejdo.examples.util.PersistenceManagerFactoryHelper;
import com.corejdo.examples.model.Author;

import javax.jdo.PersistenceManagerFactory;
import javax.jdo.PersistenceManager;
import javax.jdo.Transaction;
import javax.jdo.Query;
import java.util.Collection;
import java.util.Iterator;

public class SimpleQueryWithFilter {


    public static void main(String agrs[]) {

        // Plik waciwoci zawiera wszystkie waciwoci konfiguracji

        PersistenceManagerFactory pmf =
                PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

        PersistenceManager pm = pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();


        tx.begin();

        // wyszukuje autorw, ktrych kod pocztowy rwny jest 02929
        String filter = "address.zipcode==\"02929\" ";
        Query query = pm.newQuery(Author.class, filter);
        Collection results = (Collection) query.execute();
        if (results.isEmpty())
            System.out.println("Brak wyniku");
        else {

            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                Author author = (Author) iter.next();
                String name = author.getName();
                System.out.println("Nazwisko autora: " + name);
                System.out.println("Adres autora: " + author.getAddress());
                System.out.println("Wydane ksiki: " );
                Iterator books=author.getBooks().iterator();
                    while(books.hasNext())
                            System.out.println("Tytu:" +books.next()) ;

            }
        }
        query.closeAll();
        tx.commit();

    }
}
