package com.corejdo.examples.chapter5;

import java.util.Properties;

import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManagerFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/**
 * @author mccammon
 *
 */
public class PMFSingletonFromJNDIExample {
  
  // nazwa JNDI dla instancji PersistenceManagerFactory
  private static String name = PMFSingletonFromJNDIExample.class.getName();
  
  // singleton PersistenceManagerFactory 
  private static PersistenceManagerFactory pmf;
  
  /**
   * <p>Metoda ta zwraca singleton klasy 
   * PersistenceManagerFactory. Jeli jest to wymagane, 
   * to najpier inicjuje singleton wyszukujc go poprzez JNDI.
   * Jeli instancja PersistenceManagerFactory nie zostanie odnaleziona
   * przez JNDI, to metoda wyrzuca wyjtek JDOFatalUserException</p>
   * 
   * @return instancja PersistenceManagerFactory
   */
  public static PersistenceManagerFactory getPersistenceManagerFactory() {
    
    if (pmf == null) {
      
      try {
  
        InitialContext context = new InitialContext();
  
        pmf = (PersistenceManagerFactory) context.lookup(name);
      }
      
      catch (NamingException e) {
  
        throw new JDOFatalUserException(
          "Nie mona odnale PersistenceManagerFactory: " + name,
          e);
      }
    }
    
    return pmf;
  }

  /**
   * <p>Tworzy instancj klasy 
   * PersistenceManagerFactory instance i rejestruje j w JNDI.
   * Wymaga wyspecyfikowania waciwoci 
   * klasy PersistenceManagerFactoryClass.</p>
   *
   * @param args argumenty wiersza polece: url nazwa haso
   */
  public static void main(String[] args) {

    if (args.length != 3) {
      
      System.out.println("Niedozwolone argumenty, use: <url> <nazwa> <haso>");
      
      System.exit(-1);
    }
    
    Properties properties = new Properties();
    
    properties.put(
      "javax.jdo.PersistenceManagerFactoryClass", "XXX");
    properties.put(
      "javax.jdo.option.ConnectionURL", args[0]);
    properties.put(
      "javax.jdo.option.ConnectionUserName", args[1]);
    properties.put(
      "javax.jdo.option.ConnectionPassword", args[2]);

    PersistenceManagerFactory pmf =
      JDOHelper.getPersistenceManagerFactory(properties);

    try {

      InitialContext context = new InitialContext();

      context.bind(name, pmf);
    }
    
    catch (NamingException e) {

      System.out.println("Nie mona powiza PersistenceManager");
      
      e.printStackTrace();
    }
  }
  
  private PMFSingletonFromJNDIExample() {}
}
