package com.corejdo.examples.chapter5;

import javax.jdo.JDOException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Address;
import com.corejdo.examples.model.Author;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Address
 * @see com.corejdo.examples.model.Author
 *
 */
public class OptimisticExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw podczas uruchamiania z wiersza polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main(String[] args) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = pmf.getPersistenceManager();

    Transaction tx = pm.currentTransaction();

    tx.begin();

    Author author =
      new Author(
        "Keiron McCammon",
        new Address("6539 Dumbarton Circle", "Fremont", "CA", "94555"));

    pm.makePersistent(author);

    tx.commit();

    tx.setOptimistic(true);

    tx.begin();

    Address address = author.getAddress();

    address.setZipcode("12345");

    pm.makeTransactional(author);

    /*
     * Inna instancja PersistenceManager modyfikuje 
     * pole name wewntrz innej transakcji.
     */
    PersistenceManager pm2 = pmf.getPersistenceManager();

    Transaction tx2 = pm.currentTransaction();

    tx2.begin();

    /*
     * Tosamo instancji Author zostaje uyta do pobrania
     * tej instancji w kontekcie innej instancji 
     * PersistenceManager.
     */
    Author author2 =
      (Author) pm.getObjectById(JDOHelper.getObjectId(author), false);

    author.setName("Sameer Tyagi");

    tx2.commit();

    pm2.close();

    /*
     * Poniewa pole name zostao zmodyfikowane 
     * przez inn transakcj, to transakcja optimistyczna
     * wyrzuci wyjtek przy prbie jej zatwierdzenia.
     */

    try {

      tx.commit();
    }

    /*
     * W wersji 1.0.1 zgoszony zostanie wyjtek typu
     * JDOOptimisticVerificationException, a w wersjach wczeniejszych
     * typu JDOUserException
     */
    catch (JDOException e) {

      System.out.println("Zatwierdzenie transakcji nie powiodo si.");
    }

    pm.close();
  }

  private OptimisticExample() {}
}
