package com.corejdo.examples.chapter5;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Address;
import com.corejdo.examples.model.Author;
import com.corejdo.examples.model.Book;
import com.corejdo.examples.model.Publisher;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Address
 * @see com.corejdo.examples.model.Author
 * @see com.corejdo.examples.model.Book
 * @see com.corejdo.examples.model.Publisher
 *
 */
public class MakePersistentExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw podczas uruchamiania z wiersza polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main(String[] args) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = pmf.getPersistenceManager();

    Transaction tx = pm.currentTransaction();

    tx.begin();

    Author author =
      new Author(
        "Keiron McCammon",
        new Address("6539 Dumbarton Circle", "Fremont", "CA", "94555"));

    Publisher publisher = new Publisher("Sun Microsystems Press");

    Book book = new Book("Core Java Data Objects", "0-13-140731-7");

    author.addBook(book);

    publisher.addBook(book);

    pm.makePersistent(author);

    tx.commit();

    pm.close();
  }

  private MakePersistentExample() {}
}
