package com.corejdo.examples.chapter3;

import java.util.Iterator;

import javax.jdo.Extent;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Author;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Author
 * @see com.corejdo.examples.chapter3.CreateExample
 *
 */
public final class ReadByExtentExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw podczas uruchamiania z wiersza polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main ( String[] args ) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = pmf.getPersistenceManager();

    Transaction tx = pm.currentTransaction();
    
    tx.begin();
    
    Extent extent = pm.getExtent(Author.class, true);
    
    Iterator authors = extent.iterator();
    
    while (authors.hasNext()) {
        
      Author author = (Author) authors.next();
    
      String name = author.getName();
    
      System.out.println("Nazwisko autora: '" + name + "'.");
    }
    
    extent.close(authors);
    
    tx.commit();
    
    pm.close();
  }
  
  private ReadByExtentExample() {}
}
