package com.corejdo.casestudy.usecase;


import com.corejdo.casestudy.model.Book;
import com.corejdo.casestudy.model.Copy;
import com.corejdo.casestudy.tools.CmdLine;

/**
 * Zwraca ksik.
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */

public class ReturnBook extends BorrowReturn
{
    public static void main(String[] args)
    {
        new ReturnBook().runCmdLine(args);
    }

    /**
     * Wersja edytora dostpna w wierszu polece.
     */
    protected void run(String[] args)
    {
        setFindISBN(CmdLine.getStringVar("Podaj ISBN","1-2153-1882-3"));
        execute();
        System.out.println("Od zwracan kopi na "+location);
    }

    protected void process(Book book)
    {
        Copy copy[] = findCopies(book);
        for (int i = 0; i < copy.length; i++) {
            Copy c = copy[i];
            if (c.borrower == getContext().user) {
                c.borrower = null;
                this.location = c.location;
                return ;
            }
        }
        throw new UseCaseException("Ta ksika nie zostaa wypoyczona "+getContext().user);
    }

}
