package com.corejdo.casestudy.usecase;

import com.corejdo.casestudy.model.Right;
import com.corejdo.casestudy.model.Rights;
import com.corejdo.casestudy.model.User;
import com.corejdo.casestudy.tools.CmdLine;

/**
 * Klasa wykorzystywana do zmiany waciwoci uytkownika.
 *
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */

public class EditUser extends UserOperation
{
    public static void main(String[] args)
    {
        new EditUser().runCmdLine(args);
    }

    /**
     * Wersja uruchamiana z wiersza polece.
     *
     */
    protected void run(String[] args)
    {
        setFindUser(CmdLine.getStringVar("Identyfikator uytkownika","hb"));
        setLoad();
        try {
            execute();
        }
        catch (UserNotFoundException e)
        {
            System.out.println("Uytkownik nie zosta odnaleziony.");
            add = CmdLine.getBooleanVar("Doda?",false);
            if (!add) return;
        }
        setFirstName(CmdLine.getStringVar("Imi:",firstName));
        setLastName(CmdLine.getStringVar("Nazwisko:",lastName));
        setPassword(CmdLine.getStringVar("Haso:",password));
        setCanBorrow(CmdLine.getBooleanVar("Prawo wypoyczania:",canBorrow));
        setCanManage(CmdLine.getBooleanVar("Prawo zarzdzania publikacjami:",canManage));
        setCanModifyUser(CmdLine.getBooleanVar("Prawo zarzdzania uytkownikami",canModifyUser));

		if (add) setAdd();
         else setUpdate();
        execute();
    }


    public void setLoad()
    {
        this.update = false;
        this.add = false;
    }

    public void setUpdate()
    {
        this.update = true;
        this.add = false;
    }

    public void setAdd()
    {
        this.update = true;
        this.add = true;
    }


    public boolean isAllowed()
    {
        return getContext().userRights.canModifyUser();
    }
    /**
     * Wyszukuje ksik,a nastpnie aktualizuje jej pola
     * posugujc si wartociami tego komponentu.
     */
    protected void _execute()
    {
        User user;
        if (add) {
            user = new User();
            user.setId(this.getFindUser());
        } else {
            user = findUser();
        }
        if (update || add) {
            user.setLastName(this.lastName);
            user.setFirstName(this.firstName);
            if (this.password.length() > 0) user.setPassword(this.password);
            Rights rights = user.getRights();

            rights.setBorrow(canBorrow ? Right.ALLOWED : Right.DENIED);
            rights.setManage(canManage ? Right.ALLOWED : Right.DENIED);
            rights.setModifyUser(canModifyUser ? Right.ALLOWED : Right.DENIED);
            if (add) {
                getPM().makePersistent(user);
            }
        } else {
            this.lastName = user.getLastName();
            this.firstName = user.getFirstName();
            this.password = "";
            this.canBorrow = user.getRights().canBorrow();
            this.canModifyUser = user.getRights().canModifyUser();
            this.canManage = user.getRights().canManage();
        }
    }

    public String getFirstName()
    {
        return firstName;
    }
    public void setFirstName(String firstName)
    {
        this.firstName = firstName;
    }
    public String getId()
    {
        return id;
    }
    public String getLastName()
    {
        return lastName;
    }
    public void setLastName(String lastName)
    {
        this.lastName = lastName;
    }
    public void setPassword(String password)
    {
        this.password = password;
    }
    public boolean isCanBorrow()
    {
        return canBorrow;
    }
    public void setCanBorrow(boolean canBorrow)
    {
        this.canBorrow = canBorrow;
    }
    public boolean isCanManage()
    {
        return canManage;
    }
    public void setCanManage(boolean canManage)
    {
        this.canManage = canManage;
    }
    public void setCanModifyUser(boolean canModifyUser)
    {
        this.canModifyUser = canModifyUser;
    }
    public boolean isCanModifyUser()
    {
        return canModifyUser;
    }

    private String firstName;
    private String lastName;
    private String id;
    private String password;
    private boolean canManage;
    private boolean canBorrow;
    private boolean canModifyUser;

    private boolean update = false;
    private boolean add = false;


}
