package com.corejdo.casestudy.tools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
/**
 * Metody pomocnicze wykorzystywane w trybie konsoli.
 *
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */

public class CmdLine {

    public CmdLine() {

    }

    /**
     * Testuje klas CmdLine
     */
    public static void main(String args[])
    {
        String ret = getStringVar("Name","Heiko");
        System.out.println("return '"+ret+"'");
    }

    private static Properties argProps = new Properties();
    /**
     * Inicjuje na podstawie argumentw.
     */
    public static void init(String args[])
    {
        for (int i = 0; i < args.length; i++)
        {
            StringTokenizer tok = new StringTokenizer(args[i],"=");
            if (tok.countTokens() == 2) {
                argProps.put(tok.nextToken(),tok.nextToken());
            }
        }
    }

    /**
     * Wczytuje warto cakowit. Jeli uytkownik jej nie poda,
     * to zwracana jest warto domylna.
     */
    public static int getIntVar(String prompt, int def)
    {
        int ret = Integer.parseInt(getStringVar(prompt,""+def));
        return ret;
    }

    /**
     * Wczytuje warto logiczn z konsoli. Jeli uytkownik jej nie poda,
     * to zwracana jest warto domylna.
     */
    public static boolean getBooleanVar(String prompt, boolean def)
    {
        String s = getStringVar(prompt,""+def);
        boolean ret = s.equalsIgnoreCase("true")
                || s.equalsIgnoreCase("yes");
        return ret;
    }

    /**
     * Wczytuje dat z konsoli. Jeli uytkownik jej nie poda,
     * to zwracana jest warto domylna.
     */
    public static Date getDateVar(String prompt, Date def)
    {
        Date ret = new Date();
        try {
            ret = DateFormat.getInstance().parse(getStringVar(prompt,""+def));
        }
        catch (java.text.ParseException pex)
        {
        }
        return ret;
    }

    /**
     * Wczytuje acuch z konsoli. Jeli uytkownik go nie poda,
     * to zwracana jest warto domylna.
     */
    public static String getStringVar(String prompt, String def)
    {
        String argVal = argProps.getProperty(prompt);
        if (argVal != null) return argVal;
        if (def != null) {
            System.out.print(prompt+" ["+def+"]: ");
        } else {
            System.out.print(prompt+": ");
        }
        System.out.flush();
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line = r.readLine();
            if (line.length() == 0) line = def;
            return line;
        } catch (IOException iox) {
            throw new RuntimeException("Bd wejcia. "+iox);
        }
    }
}
