package com.corejdo.casestudy.model;

/**
 * Definiuje prawa dostpu dla uytkownikw biblioteki i ich grup.
 *
 * Stanowi przykad : zamiast definiowa kolejn klas trwa Right,
 * wartoci trjstanowe (allow, deny, default) s kodowane za pomoc wartoci 
 * cakowitych (odpowiednio: +1, -1, 0 respectively). Dla zachowania modelu, klasa
 * Right jest dostpna dla aplikacji, ale wewntrznie reprezentowana za pomoc wartoci cakowitych.
 *
 * <BR><FONT Color="red"><B>Persistent</B></FONT>
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */
public class Rights
    implements Cloneable
{
    /**
     * Prawo dodawania, modyfikacji i usuwania uytkownikw biblioteki.
     */
    private int _modifyUser;

    /**
     * Prawo wypoyczania.
     */
    private int _borrow;

    /**
     * Prawo zarzdzania publikacjami.
     */
    private int _manage;



    /**
     * Konstruktor tworzy domylny obiekt klasy Rights.
     * (Nie reprezentuje adnych uprawnie.)
     */

    public Rights()
    {
    }

    private int rightToInt(Right r)
    {
        if (r == Right.ALLOWED) return 1;
        if (r == Right.DEFAULT) return 0;
        if (r == Right.DENIED) return -1;
        throw new RuntimeException("Niedozwolona warto: "+r);
    }

    private Right intToRight(int i)
    {
        if (i == 1) return Right.ALLOWED;
        if (i == 0) return Right.DEFAULT;
        if (i == -1) return Right.DENIED;
        throw new RuntimeException("Niedozwolona warto: "+i);
    }

    public boolean canBorrow()
    {
        return intToRight(_borrow).isAllowed(Right.ALLOWED);
    }
    public boolean canManage()
    {
        return intToRight(_manage).isAllowed(Right.DENIED);
    }
    public boolean canModifyUser()
    {
        return intToRight(_modifyUser).isAllowed(Right.DENIED);
    }

    public void setBorrow(Right r)
    {
        _borrow = rightToInt(r);
    }

    public void setManage(Right r)
    {
        _manage = rightToInt(r);
    }

    public void setModifyUser(Right r)
    {
        _modifyUser = rightToInt(r);
    }

    public Rights copy()
    {
        try {
            int k = this._borrow;
            Rights r = (Rights)this.clone();
            return r;
        }
        catch (CloneNotSupportedException c) {
            throw new RuntimeException("Nieoczekiwany wyjtek: "+c);
        }
    }

    public String toString()
    {
        String res =
         ( canBorrow() ? "borrow" : "noborrow")+
         ( canManage() ? ",manage" : ",nomanage")+
         ( canModifyUser() ? ",modify" : ",nomodify");
        return res;
    }
}
