package com.corejdo.examples.chapter7;

import com.corejdo.examples.model.Author;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

import javax.jdo.Query;
import java.util.Iterator;
import java.util.Collection;
import javax.jdo.*;

public class SimpleQuery {

    public static void main(String agrs[]) {

        // Plik waciwoci zawiera wszystkie waciwoci konfiguracji

        PersistenceManagerFactory pmf =
                PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

        PersistenceManager pm = pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();


        tx.begin();
        Query query = pm.newQuery(Author.class);
        Collection results = (Collection) query.execute();
        if (results.isEmpty())
            System.out.println("Brak wyniku");
        else {
            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                Author author = (Author) iter.next();
                String name = author.getName();
                System.out.println("Nazwisko autora: " + name);
            }
        }
        query.closeAll();
        tx.commit();

    }
}
