package com.corejdo.examples.chapter7;

import com.corejdo.examples.model.Author;
import com.corejdo.examples.model.Address;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

import javax.jdo.*;


public class ObjectIdExample {

    public static void main(String[] args) throws Exception {

    // Plik waciwoci zawiera wszystkie waciwoci konfiguracji

        PersistenceManagerFactory pmf =
                PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

        PersistenceManager pm = pmf.getPersistenceManager();

    // tworzy i utrwala obiekt
        Transaction tx = pm.currentTransaction();
        tx.begin();
        Author author =
          new Author(
            "Sameer Tyagi",
            new Address(
              "1 Main Street", "Boston", "MA", "01822"));

        pm.makePersistent(author);
        Object oid= pm.getObjectId(author);
        tx.commit();


        
        // Prbuje wyszuka obiekt na podstawie jego tosamoci.

        pm = pmf.getPersistenceManager();
        tx = pm.currentTransaction();
        tx.begin();
        System.out.println("Wyszukuj obiekt o nastpujcej tosamoci: " + oid);
        Author foundauthor = (Author) pm.getObjectById(oid, false);
        System.out.println("Odnaleziony obiekt: " + foundauthor.getName());
        tx.commit();
        pm.close();
    }
}