package com.corejdo.examples.chapter7;

import com.corejdo.examples.util.PersistenceManagerFactoryHelper;
import com.corejdo.examples.model.Author;
import com.corejdo.examples.model.Book;

import javax.jdo.PersistenceManagerFactory;
import javax.jdo.PersistenceManager;
import javax.jdo.Transaction;
import javax.jdo.Query;
import java.util.Collection;
import java.util.Iterator;
import java.util.Date;

public class FilterExamples {


    public static void main(String agrs[]) {

        // Plik waciwoci zawiera wszystkie waciwoci konfiguracji

        PersistenceManagerFactory pmf =
                PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

        PersistenceManager pm = pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();


        tx.begin();
       System.out.println("--------------przykad 1-----------------------")      ;
        // wyszukuje autorw, ktrych nazwisko rozpoczyna si na liter "S"

        String filter = "name.startsWith(\"S\") ";
        Query query = pm.newQuery(Author.class, filter);
        Collection results = (Collection) query.execute();
        if (results.isEmpty())
            System.out.println("Brak wyniku");
        else {

            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                Author author = (Author) iter.next();
                String name = author.getName();
                System.out.println("Nazwisko autora: " + name);
                System.out.println("Adres autora: " + author.getAddress());
                System.out.println("Wydane ksiki: " );
                Iterator books=author.getBooks().iterator();
                while(books.hasNext())
                       System.out.println("Tytu:" +books.next()) ;

            }
        }
        query.closeAll();

       System.out.println("---------------przykad 2----------------------") ;
     // wyszukuje autorw, ktrych kod pocztowy jest rwny 02929
        filter = "address.zipcode==\"02929\"";
        query = pm.newQuery(Author.class, filter);
        results = (Collection) query.execute();
        if (results.isEmpty())
            System.out.println("Brak wyniku");
        else {

            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                Author author = (Author) iter.next();
                String name = author.getName();
                System.out.println("Nazwisko autora: " + name);
                System.out.println("Adres autora: " + author.getAddress());
                System.out.println("Wydane ksiki: " );
                Iterator books=author.getBooks().iterator();
                while(books.hasNext())
                       System.out.println("Tytu:" +books.next()) ;
              }
        }
        query.closeAll();

        System.out.println("---------------przykad 3----------------------") ;
        // Wyszukuje ksiki okrelonego wydawcy i o okrelonej dacie wydania
        filter = "(publisher.name== pubname) && (publicationDate < today)";
        query = pm.newQuery(Book.class, filter);
        Date today= new Date();
        String pubname="Pet publishin Co";
        query.declareImports("import java.util.Date;")  ;
        query.declareParameters("Publisher pubname,Date today");
        results = (Collection) query.execute(pubname,today);
        if (results.isEmpty())
            System.out.println("Brak wyniku");
        else {

            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                Book book = (Book) iter.next();
                System.out.println("Ksika: "+book);
                }
        }

        // powtarza zapytanie dla innych wartoci parametrw pubname i date

        pubname="Books123.com";
        results = (Collection) query.execute(pubname,today);
        if (results.isEmpty())
            System.out.println("Brak wyniku");
        else {

            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                Book book = (Book) iter.next();
                System.out.println("Ksika "+book);
                }
        }
        query.closeAll();

        System.out.println("---------------przykad 4----------------------") ;

        filter = "books.contains(myfavouritebook) && " +
                "(myfavouritebook.title==\"Learn Java Today\")";
        query = pm.newQuery(Author.class, filter);
        query.declareVariables("Book myfavouritebook");
        results = (Collection) query.execute();
        if (results.isEmpty())
            System.out.println("Brak wyniku");
        else {

            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                Author author = (Author) iter.next();
                String name = author.getName();
                System.out.println("Nazwisko autora: " + name);
                System.out.println("Adres autora: " + author.getAddress());
                System.out.println("Wydane ksiki: " );
                Iterator books=author.getBooks().iterator();
                while(books.hasNext())
                       System.out.println("Tytu:" +books.next()) ;

            }
        }
        query.closeAll();

        System.out.println("---------------przykad 5----------------------") ;

        query = pm.newQuery(Book.class);
        query.setOrdering("title ascending,publicationDate decending");
        results = (Collection) query.execute();
        if (results.isEmpty())
            System.out.println("Brak wyniku");
      else {

            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                Book book = (Book) iter.next();
                System.out.println("Tytu: "+book);
                }
        }
        query.closeAll();

        System.out.println("--------------przykad 6-----------------------")      ;
        // przykad rzutowania

       //  filter = "((String)name).startsWith(\"S\") ";
          filter = "name.startsWith(\"S\") ";
         query = pm.newQuery(Author.class, filter);
         results = (Collection) query.execute();
        if (results.isEmpty())
            System.out.println("Brak wyniku");
        else {

            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                Author author = (Author) iter.next();
                String name = author.getName();
                System.out.println("Nazwisko autora: " + name);
                System.out.println("Adres autora: " + author.getAddress());
                System.out.println("Wydane ksiki: " );
                Iterator books=author.getBooks().iterator();
                while(books.hasNext())
                       System.out.println("Tytu:" +books.next()) ;

            }
        }
        query.closeAll();

        System.out.println("--------------przykad 7-----------------------")      ;
  // przykad zastosowania operatora "this" 
        filter = "books.contains(name) && " +
                "(this.name==\"Steven Jones\")";
        query = pm.newQuery(Author.class, filter);
        query.declareVariables("Book name");
        results = (Collection) query.execute();
        if (results.isEmpty())
            System.out.println("Brak wyniku");
        else {

            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                Author author = (Author) iter.next();
                String name = author.getName();
                System.out.println("Nazwisko autora: " + name);
                System.out.println("Adres autora: " + author.getAddress());
                System.out.println("Wydane ksiki: " );
                Iterator books=author.getBooks().iterator();
                while(books.hasNext())
                       System.out.println("Tytu:" +books.next()) ;

            }
        }
        query.closeAll();
        tx.commit();
    }
}
