package com.corejdo.examples.chapter5;

import java.util.Collection;
import java.util.Iterator;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;

import com.corejdo.examples.model.Author;
import com.corejdo.examples.model.Book;
import com.corejdo.examples.util.PersistenceManagerFactoryHelper;

/**
 * @author mccammon
 * @see com.corejdo.examples.util.PersistenceManagerFactoryHelper
 * @see com.corejdo.examples.model.Author
 * @see com.corejdo.examples.model.Book
 * 
 */
public class SimpleQueryUsingContainsExample {

  /**
   * <p>Uywana do uruchomienia przykadu. Nie wymaga parametrw w  wierszu polece.</p>
   * 
   * @param args parametry podane w wierszu polece
   */
  public static void main(String[] args) {

    PersistenceManagerFactory pmf =
      PersistenceManagerFactoryHelper.getPersistenceManagerFactory();

    PersistenceManager pm = pmf.getPersistenceManager();

    Transaction tx = pm.currentTransaction();

    tx.begin();

    Author author = new Author("Keiron McCammon");

    author.addBook(new Book("Core Java Data Objects", "0-13-140731-7"));

    pm.makePersistent(author);

    tx.commit();

    tx.begin();

    Query query =
      pm.newQuery(
        Book.class,
        "authors.contains(author) && author.name == name");

    query.declareParameters("String name");
    query.declareVariables("Author author");

    Collection result = (Collection) query.execute("Keiron McCammon");

    Iterator iter = result.iterator();

    while (iter.hasNext()) {

      Book book = (Book) iter.next();

      System.out.println(book.getTitle() + " - " + book.getISBN());
    }

    query.close(result);

    tx.commit();

    pm.close();
  }

  private SimpleQueryUsingContainsExample() {}
}
